/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.clustering;

import java.util.ArrayList;
import java.util.List;
import teetime.framework.AbstractStage;
import teetime.framework.InputPort;
import teetime.framework.OutputPort;

public class DataCollectorStage<T>
extends AbstractStage {
    private final InputPort<T> dataInputPort = this.createInputPort();
    private final InputPort<Long> timeTriggerInputPort = this.createInputPort();
    private final OutputPort<List<T>> mTreeOutputPort = this.createOutputPort();
    private final OutputPort<List<T>> opticsOutputPort = this.createOutputPort();
    private List<T> dataList = new ArrayList<T>();
    private boolean stopAfterAmount = false;
    private int maxAmount = 0;

    public DataCollectorStage() {
        this.declareActive();
    }

    public DataCollectorStage(int amount) {
        this.declareActive();
        this.maxAmount = amount;
        this.stopAfterAmount = true;
    }

    protected void execute() throws Exception {
        Long triggerTime;
        Object newData = this.dataInputPort.receive();
        if (newData != null) {
            this.logger.debug("Received a behavior model!");
            this.dataList.add(newData);
            if (this.stopAfterAmount && this.dataList.size() >= this.maxAmount) {
                this.logger.debug("Reached model amount maximum, sending models..");
                this.opticsOutputPort.send(this.dataList);
                this.mTreeOutputPort.send(this.dataList);
                this.dataList = new ArrayList<T>();
            }
        }
        if ((triggerTime = (Long)this.timeTriggerInputPort.receive()) != null) {
            this.logger.debug("Sending models...");
            this.opticsOutputPort.send(this.dataList);
            this.mTreeOutputPort.send(this.dataList);
            this.dataList = new ArrayList<T>();
        }
    }

    protected void onTerminating() {
        this.logger.debug("Sending models...");
        this.opticsOutputPort.send(this.dataList);
        this.mTreeOutputPort.send(this.dataList);
        super.onTerminating();
    }

    public InputPort<T> getDataInputPort() {
        return this.dataInputPort;
    }

    public InputPort<Long> getTimeTriggerInputPort() {
        return this.timeTriggerInputPort;
    }

    public OutputPort<List<T>> getmTreeOutputPort() {
        return this.mTreeOutputPort;
    }

    public OutputPort<List<T>> getOpticsOutputPort() {
        return this.opticsOutputPort;
    }
}

