/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.clustering;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kieker.analysis.generic.clustering.Clustering;
import kieker.analysis.generic.clustering.optics.OpticsData;
import teetime.stage.basic.AbstractTransformation;

public class ExtractDBScanClustersStage<T>
extends AbstractTransformation<List<OpticsData<T>>, Clustering<T>> {
    private final double clusteringDistance;

    public ExtractDBScanClustersStage(double clusteringDistance) {
        this.clusteringDistance = clusteringDistance;
    }

    protected void execute(List<OpticsData<T>> opticsResults) throws Exception {
        this.logger.debug("received optics result");
        for (OpticsData<T> model : opticsResults) {
            this.logger.debug("{} and core: {}", (Object)Double.toString(model.getReachabilityDistance()), (Object)Double.toString(model.getCoreDistance()));
        }
        Clustering clustering = new Clustering();
        Set currentCluster = clustering.getNoise();
        for (OpticsData<T> model : opticsResults) {
            if (model.getReachabilityDistance() == -1.0 || model.getReachabilityDistance() > this.clusteringDistance) {
                if (model.getCoreDistance() <= this.clusteringDistance && model.getCoreDistance() != -1.0) {
                    HashSet newCluster = new HashSet();
                    clustering.addCluster(newCluster);
                    newCluster.add(model.getData());
                    currentCluster = newCluster;
                    continue;
                }
                clustering.getNoise().add(model.getData());
                continue;
            }
            currentCluster.add(model.getData());
        }
        this.logger.debug("generated {} clusters.", (Object)clustering.getClusters().size());
        this.getOutputPort().send(clustering);
    }
}

