/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.clustering;

import java.util.Set;
import kieker.analysis.generic.clustering.Clustering;
import kieker.analysis.generic.clustering.mtree.IDistanceFunction;
import kieker.analysis.generic.clustering.mtree.TrimmedAlgorithm;
import teetime.stage.basic.AbstractTransformation;

public class MedoidGenerator<T>
extends AbstractTransformation<Clustering<T>, T> {
    private final IDistanceFunction<T> distanceFunction;

    public MedoidGenerator(IDistanceFunction<T> distanceFunction) {
        this.distanceFunction = distanceFunction;
    }

    protected void execute(Clustering<T> clustering) throws Exception {
        for (Set<T> clusterSet : clustering.getClusters()) {
            Object[] cluster = clusterSet.toArray();
            if (cluster.length == 0) {
                this.logger.warn("Empty cluster received");
                return;
            }
            TrimmedAlgorithm<Object> trimed = new TrimmedAlgorithm<Object>(cluster, this.distanceFunction);
            this.outputPort.send(trimed.calculate());
        }
        this.logger.debug("gernerated all mediods of a clustering");
    }
}

