/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.clustering;

import java.util.Set;
import kieker.analysis.generic.clustering.Clustering;
import kieker.analysis.generic.clustering.mtree.IDistanceFunction;
import teetime.stage.basic.AbstractTransformation;

public class NaiveMedoidGenerator<T>
extends AbstractTransformation<Clustering<T>, T> {
    private final IDistanceFunction<T> distanceFunction;

    public NaiveMedoidGenerator(IDistanceFunction<T> distanceFunction) {
        this.distanceFunction = distanceFunction;
    }

    protected void execute(Clustering<T> clustering) throws Exception {
        for (Set<T> clusterSet : clustering.getClusters()) {
            Object[] cluster = clusterSet.toArray();
            if (cluster.length == 0) {
                this.logger.warn("Empty cluster received");
                return;
            }
            Object medoid = cluster[0];
            double minDistanceSum = Double.MAX_VALUE;
            for (int i = 0; i < cluster.length; ++i) {
                double distanceSum = 0.0;
                for (int j = 0; j < cluster.length; ++j) {
                    if (i == j) continue;
                    distanceSum += this.distanceFunction.calculate(cluster[i], cluster[j]);
                }
                if (!(distanceSum < minDistanceSum)) continue;
                minDistanceSum = distanceSum;
                medoid = cluster[i];
            }
            this.outputPort.send(medoid);
        }
        this.logger.debug("mediod generated");
    }
}

