/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.clustering.mtree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import kieker.analysis.generic.clustering.mtree.IDistanceFunction;
import kieker.analysis.generic.clustering.mtree.IPartitionFunction;
import kieker.analysis.generic.clustering.mtree.utils.Pair;

public final class BalancedPartitionFunction<T>
implements IPartitionFunction<T> {
    @Override
    public Pair<Set<T>> process(final Pair<T> promoted, Set<T> dataSet, final IDistanceFunction<? super T> distanceFunction) {
        ArrayList<T> queue1 = new ArrayList<T>(dataSet);
        Collections.sort(queue1, new Comparator<T>(){

            @Override
            public int compare(T data1, T data2) {
                double distance1 = distanceFunction.calculate(data1, promoted.getFirst());
                double distance2 = distanceFunction.calculate(data2, promoted.getFirst());
                return Double.compare(distance1, distance2);
            }
        });
        ArrayList<T> queue2 = new ArrayList<T>(dataSet);
        Collections.sort(queue2, new Comparator<T>(){

            @Override
            public int compare(T data1, T data2) {
                double distance1 = distanceFunction.calculate(data1, promoted.getSecond());
                double distance2 = distanceFunction.calculate(data2, promoted.getSecond());
                return Double.compare(distance1, distance2);
            }
        });
        Pair<Set<T>> partitions = new Pair<Set<T>>(new HashSet(), new HashSet());
        int index1 = 0;
        int index2 = 0;
        block0: while (index1 < queue1.size() || index2 != queue2.size()) {
            Object data;
            while (index1 < queue1.size()) {
                data = queue1.get(index1++);
                if (partitions.getSecond().contains(data)) continue;
                partitions.getFirst().add(data);
                break;
            }
            while (index2 < queue2.size()) {
                data = queue2.get(index2++);
                if (partitions.getFirst().contains(data)) continue;
                partitions.getSecond().add(data);
                continue block0;
            }
        }
        return partitions;
    }
}

