/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.clustering.mtree;

import java.util.Set;
import kieker.analysis.generic.clustering.mtree.IDistanceFunction;
import kieker.analysis.generic.clustering.mtree.IPartitionFunction;
import kieker.analysis.generic.clustering.mtree.IPromotionFunction;
import kieker.analysis.generic.clustering.mtree.ISplitFunction;
import kieker.analysis.generic.clustering.mtree.utils.Pair;

public class ComposedSplitFunction<T>
implements ISplitFunction<T> {
    private final IPromotionFunction<T> promotionFunction;
    private final IPartitionFunction<T> partitionFunction;

    public ComposedSplitFunction(IPromotionFunction<T> promotionFunction, IPartitionFunction<T> partitionFunction) {
        this.promotionFunction = promotionFunction;
        this.partitionFunction = partitionFunction;
    }

    @Override
    public ISplitFunction.SplitResult<T> process(Set<T> dataSet, IDistanceFunction<? super T> distanceFunction) {
        Pair<? super T> promoted = this.promotionFunction.process(dataSet, distanceFunction);
        Pair partitions = this.partitionFunction.process(promoted, dataSet, distanceFunction);
        return new ISplitFunction.SplitResult<T>(promoted, partitions);
    }
}

