/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.clustering.mtree;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kieker.analysis.generic.clustering.mtree.IDistanceFunction;

public final class DistanceFunctionFactory {
    public static final IDistanceFunction<IEuclideanCoordinate> EUCLIDEAN = new IDistanceFunction<IEuclideanCoordinate>(){

        @Override
        public double calculate(IEuclideanCoordinate coord1, IEuclideanCoordinate coord2) {
            return DistanceFunctionFactory.euclidean(coord1, coord2);
        }
    };
    public static final IDistanceFunction<List<Integer>> EUCLIDEAN_INTEGER_LIST = new IDistanceFunction<List<Integer>>(){

        @Override
        public double calculate(List<Integer> data1, List<Integer> data2) {
            class IntegerListEuclideanCoordinate
            implements IEuclideanCoordinate {
                private final List<Integer> list;

                public IntegerListEuclideanCoordinate(List<Integer> list) {
                    this.list = list;
                }

                @Override
                public int dimensions() {
                    return this.list.size();
                }

                @Override
                public double get(int index) {
                    return this.list.get(index).intValue();
                }
            }
            IntegerListEuclideanCoordinate coord1 = new IntegerListEuclideanCoordinate(data1);
            IntegerListEuclideanCoordinate coord2 = new IntegerListEuclideanCoordinate(data2);
            return DistanceFunctionFactory.euclidean(coord1, coord2);
        }
    };
    public static final IDistanceFunction<List<Double>> EUCLIDEAN_DOUBLE_LIST = new IDistanceFunction<List<Double>>(){

        @Override
        public double calculate(List<Double> data1, List<Double> data2) {
            class DoubleListEuclideanCoordinate
            implements IEuclideanCoordinate {
                private final List<Double> list;

                public DoubleListEuclideanCoordinate(List<Double> list) {
                    this.list = list;
                }

                @Override
                public int dimensions() {
                    return this.list.size();
                }

                @Override
                public double get(int index) {
                    return this.list.get(index);
                }
            }
            DoubleListEuclideanCoordinate coord1 = new DoubleListEuclideanCoordinate(data1);
            DoubleListEuclideanCoordinate coord2 = new DoubleListEuclideanCoordinate(data2);
            return DistanceFunctionFactory.euclidean(coord1, coord2);
        }
    };

    private DistanceFunctionFactory() {
    }

    public static <D> IDistanceFunction<D> cached(final IDistanceFunction<D> distanceFunction) {
        return new IDistanceFunction<D>(){
            private final Map<Pair, Double> cache = new HashMap<Pair, Double>();

            @Override
            public double calculate(D data1, D data2) {
                Pair pair1 = new Pair(data1, data2);
                Double distance = this.cache.get(pair1);
                if (distance != null) {
                    return distance;
                }
                Pair pair2 = new Pair(data2, data1);
                distance = this.cache.get(pair2);
                if (distance != null) {
                    return distance;
                }
                distance = distanceFunction.calculate(data1, data2);
                this.cache.put(pair1, distance);
                this.cache.put(pair2, distance);
                return distance;
            }

            class Pair {
                private final D data1;
                private final D data2;

                public Pair(D data1, D data2) {
                    this.data1 = data1;
                    this.data2 = data2;
                }

                public int hashCode() {
                    return this.data1.hashCode() ^ this.data2.hashCode();
                }

                public boolean equals(Object arg0) {
                    if (arg0 instanceof Pair) {
                        Pair that = (Pair)arg0;
                        return this.data1.equals(that.data1) && this.data2.equals(that.data2);
                    }
                    return false;
                }
            }
        };
    }

    public static double euclidean(IEuclideanCoordinate coord1, IEuclideanCoordinate coord2) {
        int size = Math.min(coord1.dimensions(), coord2.dimensions());
        double distance = 0.0;
        for (int i = 0; i < size; ++i) {
            double diff = coord1.get(i) - coord2.get(i);
            distance += diff * diff;
        }
        distance = Math.sqrt(distance);
        return distance;
    }

    public static interface IEuclideanCoordinate {
        public int dimensions();

        public double get(int var1);
    }
}

