/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.clustering.mtree;

import kieker.analysis.exception.InternalErrorException;
import kieker.analysis.generic.clustering.mtree.BalancedPartitionFunction;
import kieker.analysis.generic.clustering.mtree.ComposedSplitFunction;
import kieker.analysis.generic.clustering.mtree.IDistanceFunction;
import kieker.analysis.generic.clustering.mtree.ISplitFunction;
import kieker.analysis.generic.clustering.mtree.RandomPromotionFunction;
import kieker.analysis.generic.clustering.mtree.nodes.AbstractNode;
import kieker.analysis.generic.clustering.mtree.nodes.IndexItem;
import kieker.analysis.generic.clustering.mtree.nodes.InternalNode;
import kieker.analysis.generic.clustering.mtree.nodes.LeafNode;
import kieker.analysis.generic.clustering.mtree.nodes.NodeFactory;
import kieker.analysis.generic.clustering.mtree.query.Query;
import kieker.analysis.generic.clustering.mtree.utils.Pair;

public class MTree<T> {
    public static final int DEFAULT_MIN_NODE_CAPACITY = 50;
    private int minNodeCapacity;
    private int maxNodeCapacity;
    private IDistanceFunction<? super T> distanceFunction;
    private ISplitFunction<T> splitFunction;
    private AbstractNode<T> root;

    public MTree(IDistanceFunction<? super T> distanceFunction, ISplitFunction<T> splitFunction) {
        this(50, distanceFunction, splitFunction);
    }

    public MTree(int minNodeCapacity, IDistanceFunction<? super T> distanceFunction, ISplitFunction<T> splitFunction) {
        this(minNodeCapacity, 2 * minNodeCapacity - 1, distanceFunction, splitFunction);
    }

    public MTree(int minNodeCapacity, int maxNodeCapacity, IDistanceFunction<? super T> distanceFunction, ISplitFunction<T> existingSplitFunction) {
        if (minNodeCapacity < 2 || maxNodeCapacity <= minNodeCapacity || distanceFunction == null) {
            throw new IllegalArgumentException();
        }
        this.splitFunction = existingSplitFunction == null ? new ComposedSplitFunction(new RandomPromotionFunction(), new BalancedPartitionFunction()) : existingSplitFunction;
        this.minNodeCapacity = minNodeCapacity;
        this.maxNodeCapacity = maxNodeCapacity;
        this.distanceFunction = distanceFunction;
        this.root = null;
    }

    public void add(T data) throws InternalErrorException {
        if (this.root == null) {
            this.root = NodeFactory.createRootLeafNode(this, data);
            this.root.addData(data, 0.0);
            if (this.root.isMaxCapacityExceeded()) {
                throw new InternalErrorException("Node capacity exceeded when adding initial root node.");
            }
        } else {
            double distance = this.distanceFunction.calculate(data, this.root.getData());
            this.root.addData(data, distance);
            if (this.root.isMaxCapacityExceeded()) {
                Pair<AbstractNode<T>> newNodes = this.root.splitNodes();
                this.createNewRootAfterSplit(newNodes, data);
            }
        }
    }

    public boolean remove(T data) throws InternalErrorException {
        if (this.root == null) {
            return false;
        }
        double distanceToRoot = this.distanceFunction.calculate(data, this.root.getData());
        if (this.root.removeData(data, distanceToRoot)) {
            if (this.root.isNodeUnderCapacity()) {
                this.root = this.root.getChildren().values().size() > 0 ? this.createNewRootAfterRemove(this.root) : null;
            }
            return true;
        }
        return false;
    }

    public Query<T> getNearestByRange(T queryData, double range) {
        return this.getNearest(queryData, range, Integer.MAX_VALUE);
    }

    public Query<T> getNearestByLimit(T queryData, int limit) {
        return this.getNearest(queryData, Double.POSITIVE_INFINITY, limit);
    }

    public Query<T> getNearest(T queryData, double range, int limit) {
        return new Query<T>(this, queryData, range, limit);
    }

    public Query<T> getNearest(T queryData) {
        return new Query<T>(this, queryData, Double.POSITIVE_INFINITY, Integer.MAX_VALUE);
    }

    public int getMaxNodeCapacity() {
        return this.maxNodeCapacity;
    }

    public int getMinNodeCapacity() {
        return this.minNodeCapacity;
    }

    public ISplitFunction<T> getSplitFunction() {
        return this.splitFunction;
    }

    public IDistanceFunction<? super T> getDistanceFunction() {
        return this.distanceFunction;
    }

    public AbstractNode<T> getRoot() {
        return this.root;
    }

    protected void check() {
        if (this.root != null) {
            this.root.check();
        }
    }

    private AbstractNode<T> createNewRootAfterRemove(AbstractNode<T> oldRoot) throws InternalErrorException {
        AbstractNode newRoot;
        AbstractNode theChild = (AbstractNode)oldRoot.getChildren().values().iterator().next();
        if (theChild instanceof InternalNode) {
            newRoot = NodeFactory.createRootNode(this, theChild.getData());
        } else {
            assert (theChild instanceof LeafNode);
            newRoot = NodeFactory.createRootLeafNode(this, theChild.getData());
        }
        for (IndexItem grandchild : theChild.getChildren().values()) {
            double newDistance = this.distanceFunction.calculate(newRoot.getData(), grandchild.getData());
            newRoot.addChild(grandchild, newDistance);
        }
        theChild.getChildren().clear();
        return newRoot;
    }

    private void createNewRootAfterSplit(Pair<AbstractNode<T>> nodes, T data) throws InternalErrorException {
        this.root = NodeFactory.createRootNode(this, data);
        this.computeDistances(nodes.getFirst());
        this.computeDistances(nodes.getSecond());
    }

    private void computeDistances(AbstractNode<T> node) throws InternalErrorException {
        double distance = this.distanceFunction.calculate(this.root.getData(), node.getData());
        this.root.addChild(node, distance);
    }
}

