/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.clustering.mtree;

import java.util.List;
import kieker.analysis.generic.clustering.mtree.IDistanceFunction;
import kieker.analysis.generic.clustering.mtree.MTree;
import teetime.stage.basic.AbstractTransformation;

public class MTreeGeneratorStage<T>
extends AbstractTransformation<List<T>, MTree<T>> {
    private final IDistanceFunction<T> distanceFunction;
    private int minNodeCapacity = 25;
    private int maxNodeCapacity = 49;

    public MTreeGeneratorStage(IDistanceFunction<T> distanceFunction) {
        this.distanceFunction = distanceFunction;
    }

    public MTreeGeneratorStage(IDistanceFunction<T> distanceFunction, int minNodeCapacity, int maxNodeCapacity) {
        this.distanceFunction = distanceFunction;
        this.minNodeCapacity = minNodeCapacity;
        this.maxNodeCapacity = maxNodeCapacity;
    }

    protected void execute(List<T> models) throws Exception {
        MTree<T> mtree = new MTree<T>(this.minNodeCapacity, this.maxNodeCapacity, this.distanceFunction, null);
        if (models != null) {
            this.logger.debug("Received {} new models", (Object)models.size());
            for (T model : models) {
                mtree.add(model);
            }
            this.logger.debug("Created MTree");
            this.outputPort.send(mtree);
        } else {
            this.logger.warn("Received empty model list. Cannot create mtree.");
        }
    }

    public int getMaxNodeCapacity() {
        return this.maxNodeCapacity;
    }

    public void setMaxNodeCapacity(int maxNodeCapacity) {
        this.maxNodeCapacity = maxNodeCapacity;
    }

    public int getMinNodeCapacity() {
        return this.minNodeCapacity;
    }

    public void setMinNodeCapacity(int minNodeCapacity) {
        this.minNodeCapacity = minNodeCapacity;
    }
}

