/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.clustering.mtree;

import kieker.analysis.generic.clustering.mtree.IDistanceFunction;

public class TrimmedAlgorithm<T> {
    private final double[] lowerBounds;
    private double lowestEnergy = Double.MAX_VALUE;
    private T bestCandidate = null;
    private final T[] models;
    private final IDistanceFunction<T> distanceFunction;

    public TrimmedAlgorithm(T[] models, IDistanceFunction<T> distanceFunction) {
        if (models.length == 0) {
            throw new IllegalArgumentException("Amount of models has to be larger than 0.");
        }
        this.lowerBounds = new double[models.length];
        this.models = models;
        this.distanceFunction = distanceFunction;
    }

    public T calculate() {
        this.bestCandidate = this.models[0];
        for (int i = 0; i < this.models.length; ++i) {
            int j;
            if (!(this.lowerBounds[i] < this.lowestEnergy)) continue;
            double[] distances = new double[this.models.length];
            double distanceSum = 0.0;
            for (j = 0; j < this.models.length; ++j) {
                distances[j] = this.distanceFunction.calculate(this.models[i], this.models[j]);
                distanceSum += distances[j];
            }
            this.lowerBounds[i] = distanceSum / (double)(this.models.length - 1);
            if (this.lowerBounds[i] < this.lowestEnergy) {
                this.lowestEnergy = this.lowerBounds[i];
                this.bestCandidate = this.models[i];
            }
            for (j = 0; j < this.models.length; ++j) {
                Math.max(this.lowerBounds[j], Math.abs(this.lowerBounds[i] - distances[j]));
            }
        }
        return this.bestCandidate;
    }
}

