/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.clustering.mtree.nodes;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kieker.analysis.exception.InternalErrorException;
import kieker.analysis.generic.clustering.mtree.DistanceFunctionFactory;
import kieker.analysis.generic.clustering.mtree.IDistanceFunction;
import kieker.analysis.generic.clustering.mtree.ILeafness;
import kieker.analysis.generic.clustering.mtree.IRootness;
import kieker.analysis.generic.clustering.mtree.ISplitFunction;
import kieker.analysis.generic.clustering.mtree.MTree;
import kieker.analysis.generic.clustering.mtree.nodes.IndexItem;
import kieker.analysis.generic.clustering.mtree.utils.Pair;

public abstract class AbstractNode<T>
extends IndexItem<T> {
    protected IRootness rootness;
    protected ILeafness<T> leafness;
    private final Map<T, IndexItem<T>> children = new HashMap<T, IndexItem<T>>();
    private final MTree<T> mtree;

    protected AbstractNode(MTree<T> mtree, T data) {
        super(data);
        this.mtree = mtree;
    }

    public Map<T, IndexItem<T>> getChildren() {
        return this.children;
    }

    public final void addData(T data, double distance) throws InternalErrorException {
        this.doAddData(data, distance);
    }

    @Override
    public int check() {
        super.check();
        this.checkMinCapacity();
        this.checkMaxCapacity();
        int childHeight = -1;
        for (Map.Entry<T, IndexItem<T>> e : this.children.entrySet()) {
            T data = e.getKey();
            IndexItem<T> child = e.getValue();
            assert (child.getData().equals(data));
            this.checkChildClass(child);
            this.checkChildMetrics(child);
            int height = child.check();
            if (childHeight < 0) {
                childHeight = height;
                continue;
            }
            assert (childHeight == height);
        }
        return childHeight + 1;
    }

    protected void doAddData(T data, double distance) throws InternalErrorException {
        this.leafness.doAddData(data, distance);
    }

    protected boolean doRemoveData(T data, double distance) throws InternalErrorException {
        return this.leafness.doRemoveData(data, distance);
    }

    public final boolean isMaxCapacityExceeded() throws InternalErrorException {
        return this.children.size() > this.mtree.getMaxNodeCapacity();
    }

    public final Pair<AbstractNode<T>> splitNodes() throws InternalErrorException {
        IDistanceFunction<T> cachedDistanceFunction = DistanceFunctionFactory.cached(this.mtree.getDistanceFunction());
        ISplitFunction.SplitResult<T> splitResult = this.mtree.getSplitFunction().process(this.children.keySet(), cachedDistanceFunction);
        AbstractNode<T> newNode0 = this.createNewNode(splitResult, cachedDistanceFunction, 0);
        AbstractNode<T> newNode1 = this.createNewNode(splitResult, cachedDistanceFunction, 1);
        assert (this.children.isEmpty());
        return new Pair<AbstractNode<T>>(newNode0, newNode1);
    }

    private AbstractNode<T> createNewNode(ISplitFunction.SplitResult<T> splitResult, IDistanceFunction<? super T> distanceFunction, int resultIndex) throws InternalErrorException {
        T promotedData = splitResult.getPromoted().get(resultIndex);
        Set<T> partition = splitResult.getPartitions().get(resultIndex);
        AbstractNode<T> newNode = this.newSplitNodeReplacement(promotedData);
        for (T data : partition) {
            IndexItem<T> child = this.children.get(data);
            this.children.remove(data);
            double distance = distanceFunction.calculate(promotedData, data);
            newNode.addChild(child, distance);
        }
        return newNode;
    }

    protected AbstractNode<T> newSplitNodeReplacement(T data) {
        return this.leafness.newSplitNodeReplacement(data);
    }

    public void addChild(IndexItem<T> child, double distance) throws InternalErrorException {
        this.leafness.addChild(child, distance);
    }

    public boolean removeData(T data, double distance) throws InternalErrorException {
        return this.doRemoveData(data, distance);
    }

    public boolean isNodeUnderCapacity() throws InternalErrorException {
        return this.children.size() < this.getMinCapacity();
    }

    protected int getMinCapacity() throws InternalErrorException {
        return this.rootness.getMinCapacity();
    }

    public void updateMetrics(IndexItem<T> child, double distance) {
        child.setDistanceToParent(distance);
        this.updateRadius(child);
    }

    public void updateRadius(IndexItem<T> child) {
        this.radius = Math.max(this.radius, child.getDistanceToParent() + child.getRadius());
    }

    public void checkMinCapacity() {
        this.rootness.checkMinCapacity();
    }

    private void checkMaxCapacity() {
        assert (this.children.size() <= this.mtree.getMaxNodeCapacity());
    }

    private void checkChildClass(IndexItem<T> child) {
        this.leafness.checkChildClass(child);
    }

    private void checkChildMetrics(IndexItem<T> child) {
        double dist = this.mtree.getDistanceFunction().calculate(child.getData(), this.getData());
        assert (child.getDistanceToParent() == dist);
        double sum = child.getDistanceToParent() + child.getRadius();
        assert (sum <= this.radius);
    }

    @Override
    protected void checkDistanceToParent() {
        this.rootness.checkDistanceToParent();
    }

    public MTree<T> getMTree() {
        return this.mtree;
    }
}

