/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.clustering.mtree.nodes;

import kieker.analysis.generic.clustering.mtree.ILeafness;
import kieker.analysis.generic.clustering.mtree.nodes.AbstractNode;
import kieker.analysis.generic.clustering.mtree.nodes.AbstractNodeTrait;
import kieker.analysis.generic.clustering.mtree.nodes.Entry;
import kieker.analysis.generic.clustering.mtree.nodes.IndexItem;
import kieker.analysis.generic.clustering.mtree.nodes.NodeFactory;

public class LeafNodeTrait<T>
extends AbstractNodeTrait<T>
implements ILeafness<T> {
    public LeafNodeTrait(AbstractNode<T> thisNode) {
        super(thisNode);
    }

    @Override
    public void doAddData(T data, double distance) {
        Entry<T> entry = new Entry<T>(data);
        assert (!this.thisNode.getChildren().containsKey(data));
        this.thisNode.getChildren().put(data, entry);
        assert (this.thisNode.getChildren().containsKey(data));
        this.thisNode.updateMetrics(entry, distance);
    }

    @Override
    public void addChild(IndexItem<T> child, double distance) {
        assert (!this.thisNode.getChildren().containsKey(child.getData()));
        this.thisNode.getChildren().put(child.getData(), child);
        assert (this.thisNode.getChildren().containsKey(child.getData()));
        this.thisNode.updateMetrics(child, distance);
    }

    @Override
    public AbstractNode<T> newSplitNodeReplacement(T data) {
        return NodeFactory.createLeafNode(this.thisNode.getMTree(), data);
    }

    @Override
    public boolean doRemoveData(T data, double distance) {
        return this.thisNode.getChildren().remove(data) != null;
    }

    @Override
    public void checkChildClass(IndexItem<T> child) {
        assert (child instanceof Entry);
    }
}

