/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.clustering.mtree.nodes;

import kieker.analysis.generic.clustering.mtree.MTree;
import kieker.analysis.generic.clustering.mtree.nodes.InternalNode;
import kieker.analysis.generic.clustering.mtree.nodes.LeafNode;
import kieker.analysis.generic.clustering.mtree.nodes.LeafNodeTrait;
import kieker.analysis.generic.clustering.mtree.nodes.NonLeafNodeTrait;
import kieker.analysis.generic.clustering.mtree.nodes.NonRootNodeTrait;
import kieker.analysis.generic.clustering.mtree.nodes.RootLeafNode;
import kieker.analysis.generic.clustering.mtree.nodes.RootNode;
import kieker.analysis.generic.clustering.mtree.nodes.RootNodeTrait;

public final class NodeFactory {
    private NodeFactory() {
    }

    public static <R> RootNode<R> createRootNode(MTree<R> mtree, R data) {
        RootNode<R> node = new RootNode<R>(mtree, data);
        node.rootness = new RootNodeTrait<R>(node);
        node.leafness = new NonLeafNodeTrait<R>(node);
        return node;
    }

    public static <R> RootLeafNode<R> createRootLeafNode(MTree<R> mtree, R data) {
        RootLeafNode<R> node = new RootLeafNode<R>(mtree, data);
        node.rootness = new RootNodeTrait<R>(node);
        node.leafness = new LeafNodeTrait<R>(node);
        return node;
    }

    public static <R> LeafNode<R> createLeafNode(MTree<R> mtree, R data) {
        LeafNode<R> node = new LeafNode<R>(mtree, data);
        node.rootness = new NonRootNodeTrait<R>(node);
        node.leafness = new LeafNodeTrait<R>(node);
        return node;
    }

    public static <R> InternalNode<R> createInternalNode(MTree<R> mtree, R data) {
        InternalNode<R> node = new InternalNode<R>(mtree, data);
        node.rootness = new NonRootNodeTrait<R>(node);
        node.leafness = new NonLeafNodeTrait<R>(node);
        return node;
    }
}

