/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.clustering.mtree.nodes;

import java.util.ArrayDeque;
import java.util.Deque;
import kieker.analysis.exception.InternalErrorException;
import kieker.analysis.generic.clustering.mtree.ILeafness;
import kieker.analysis.generic.clustering.mtree.nodes.AbstractNode;
import kieker.analysis.generic.clustering.mtree.nodes.AbstractNodeTrait;
import kieker.analysis.generic.clustering.mtree.nodes.IndexItem;
import kieker.analysis.generic.clustering.mtree.nodes.InternalNode;
import kieker.analysis.generic.clustering.mtree.nodes.LeafNode;
import kieker.analysis.generic.clustering.mtree.nodes.NodeFactory;
import kieker.analysis.generic.clustering.mtree.utils.Pair;

public class NonLeafNodeTrait<T>
extends AbstractNodeTrait<T>
implements ILeafness<T> {
    public NonLeafNodeTrait(AbstractNode<T> thisNode) {
        super(thisNode);
    }

    @Override
    public void doAddData(T data, double distance) throws InternalErrorException {
        final class CandidateChild {
            private final AbstractNode<T> node;
            private final double distance;
            private final double metric;

            private CandidateChild(AbstractNode<T> node, double distance, double metric) {
                this.node = node;
                this.distance = distance;
                this.metric = metric;
            }
        }
        CandidateChild minRadiusIncreaseNeeded = new CandidateChild(null, -1.0, Double.POSITIVE_INFINITY);
        CandidateChild nearestDistance = new CandidateChild(null, -1.0, Double.POSITIVE_INFINITY);
        for (IndexItem item : this.thisNode.getChildren().values()) {
            AbstractNode child = (AbstractNode)item;
            double childDistance = this.thisNode.getMTree().getDistanceFunction().calculate(child.getData(), data);
            if (childDistance > child.radius) {
                double radiusIncrease = childDistance - child.radius;
                if (!(radiusIncrease < minRadiusIncreaseNeeded.metric)) continue;
                minRadiusIncreaseNeeded = new CandidateChild(child, childDistance, radiusIncrease);
                continue;
            }
            if (!(childDistance < nearestDistance.metric)) continue;
            nearestDistance = new CandidateChild(child, childDistance, childDistance);
        }
        CandidateChild chosen = nearestDistance.node != null ? nearestDistance : minRadiusIncreaseNeeded;
        AbstractNode<T> child = chosen.node;
        child.addData(data, chosen.distance);
        if (child.isMaxCapacityExceeded()) {
            Pair newNodes = child.splitNodes();
            IndexItem itemIndex = this.thisNode.getChildren().remove(child.getData());
            assert (itemIndex != null);
            this.computeDistances2(newNodes.getFirst());
            this.computeDistances2(newNodes.getSecond());
        } else {
            this.thisNode.updateRadius(child);
        }
    }

    private void computeDistances2(AbstractNode<T> node) throws InternalErrorException {
        double newDistance = this.thisNode.getMTree().getDistanceFunction().calculate(this.thisNode.getData(), node.getData());
        this.thisNode.addChild(node, newDistance);
    }

    @Override
    public void addChild(IndexItem<T> inputNewChildNode, double inputDistance) throws InternalErrorException {
        double distance = inputDistance;
        AbstractNode newChildNode = (AbstractNode)inputNewChildNode;
        ArrayDeque<ChildWithDistance> newChildren = new ArrayDeque<ChildWithDistance>();
        newChildren.addFirst(new ChildWithDistance(newChildNode, distance));
        while (!newChildren.isEmpty()) {
            ChildWithDistance cwd = (ChildWithDistance)newChildren.removeFirst();
            newChildNode = cwd.child;
            distance = cwd.distance;
            if (this.thisNode.getChildren().containsKey(newChildNode.getData())) {
                AbstractNode existingChild = (AbstractNode)this.thisNode.getChildren().get(newChildNode.getData());
                assert (existingChild.getData().equals(newChildNode.getData()));
                for (IndexItem grandchild : newChildNode.getChildren().values()) {
                    existingChild.addChild(grandchild, grandchild.getDistanceToParent());
                }
                newChildNode.getChildren().clear();
                if (!existingChild.isMaxCapacityExceeded()) continue;
                Pair newNodes = existingChild.splitNodes();
                IndexItem indexItem = this.thisNode.getChildren().remove(existingChild.getData());
                assert (indexItem != null);
                this.computeDistances(newNodes.getFirst(), newChildren);
                this.computeDistances(newNodes.getSecond(), newChildren);
                continue;
            }
            this.thisNode.getChildren().put(newChildNode.getData(), newChildNode);
            this.thisNode.updateMetrics(newChildNode, distance);
        }
    }

    private void computeDistances(AbstractNode<T> node, Deque<ChildWithDistance> newChildren) {
        double newDistance = this.thisNode.getMTree().getDistanceFunction().calculate(this.thisNode.getData(), node.getData());
        newChildren.addFirst(new ChildWithDistance(node, newDistance));
    }

    @Override
    public AbstractNode<T> newSplitNodeReplacement(T data) {
        return NodeFactory.createInternalNode(this.thisNode.getMTree(), data);
    }

    @Override
    public boolean doRemoveData(T data, double distance) throws InternalErrorException {
        for (IndexItem childItem : this.thisNode.getChildren().values()) {
            boolean dataRemoved;
            double distanceToChild;
            AbstractNode child = (AbstractNode)childItem;
            if (!(Math.abs(distance - child.getDistanceToParent()) <= child.radius) || !((distanceToChild = this.thisNode.getMTree().getDistanceFunction().calculate(data, child.getData())) <= child.radius) || !(dataRemoved = child.removeData(data, distanceToChild))) continue;
            if (child.isNodeUnderCapacity()) {
                AbstractNode<T> expandedChild = this.balanceChildren(child);
                this.thisNode.updateRadius(expandedChild);
            } else {
                this.thisNode.updateRadius(child);
            }
            return true;
        }
        return false;
    }

    private AbstractNode<T> balanceChildren(AbstractNode<T> theChild) throws InternalErrorException {
        AbstractNode nearestDonor = null;
        double distanceNearestDonor = Double.POSITIVE_INFINITY;
        IndexItem nearestMergeCandidate = null;
        double distanceNearestMergeCandidate = Double.POSITIVE_INFINITY;
        for (IndexItem child : this.thisNode.getChildren().values()) {
            AbstractNode anotherChild = (AbstractNode)child;
            if (anotherChild == theChild) continue;
            double distance = this.thisNode.getMTree().getDistanceFunction().calculate(theChild.getData(), anotherChild.getData());
            if (anotherChild.getChildren().size() > anotherChild.getMinCapacity()) {
                if (!(distance < distanceNearestDonor)) continue;
                distanceNearestDonor = distance;
                nearestDonor = anotherChild;
                continue;
            }
            if (!(distance < distanceNearestMergeCandidate)) continue;
            distanceNearestMergeCandidate = distance;
            nearestMergeCandidate = anotherChild;
        }
        if (nearestDonor == null) {
            for (IndexItem grandchild : theChild.getChildren().values()) {
                double distance = this.thisNode.getMTree().getDistanceFunction().calculate(grandchild.getData(), nearestMergeCandidate.getData());
                ((AbstractNode)nearestMergeCandidate).addChild(grandchild, distance);
            }
            IndexItem removed = this.thisNode.getChildren().remove(theChild.getData());
            assert (removed != null);
            return nearestMergeCandidate;
        }
        IndexItem nearestGrandchild = null;
        double nearestGrandchildDistance = Double.POSITIVE_INFINITY;
        for (IndexItem grandchild : nearestDonor.getChildren().values()) {
            double distance = this.thisNode.getMTree().getDistanceFunction().calculate(grandchild.getData(), theChild.getData());
            if (!(distance < nearestGrandchildDistance)) continue;
            nearestGrandchildDistance = distance;
            nearestGrandchild = grandchild;
        }
        IndexItem indexItem = nearestDonor.getChildren().remove(nearestGrandchild.getData());
        assert (indexItem != null);
        theChild.addChild(nearestGrandchild, nearestGrandchildDistance);
        return theChild;
    }

    @Override
    public void checkChildClass(IndexItem<T> child) {
        assert (child instanceof InternalNode || child instanceof LeafNode);
    }

    final class ChildWithDistance {
        private final AbstractNode<T> child;
        private final double distance;

        private ChildWithDistance(AbstractNode<T> child, double distance) {
            this.child = child;
            this.distance = distance;
        }
    }
}

