/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.clustering.mtree.query;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import kieker.analysis.generic.clustering.mtree.nodes.AbstractNode;
import kieker.analysis.generic.clustering.mtree.nodes.Entry;
import kieker.analysis.generic.clustering.mtree.nodes.IndexItem;
import kieker.analysis.generic.clustering.mtree.query.Query;
import kieker.analysis.generic.clustering.mtree.query.ResultItem;

public final class ResultsIterator<T>
implements Iterator<ResultItem<T>> {
    private ResultItem<T> nextResultItem = null;
    private boolean finished = false;
    private final PriorityQueue<ItemWithDistances<AbstractNode<T>>> pendingQueue = new PriorityQueue();
    private double nextPendingMinDistance;
    private final PriorityQueue<ItemWithDistances<Entry<T>>> nearestQueue = new PriorityQueue();
    private int yieldedCount;
    private Query<T> query;

    public ResultsIterator(Query<T> query) {
        this.query = query;
        if (this.query.getMTree().getRoot() == null) {
            this.finished = true;
            return;
        }
        double distance = this.query.getMTree().getDistanceFunction().calculate(this.query.getData(), this.query.getMTree().getRoot().getData());
        double minDistance = Math.max(distance - this.query.getMTree().getRoot().getRadius(), 0.0);
        this.pendingQueue.add(new ItemWithDistances<AbstractNode<T>>(this.query.getMTree().getRoot(), distance, minDistance));
        this.nextPendingMinDistance = minDistance;
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.nextResultItem == null) {
            this.fetchNext();
        }
        if (this.nextResultItem == null) {
            this.finished = true;
            return false;
        }
        return true;
    }

    @Override
    public ResultItem<T> next() {
        if (this.hasNext()) {
            ResultItem<T> next = this.nextResultItem;
            this.nextResultItem = null;
            return next;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void fetchNext() {
        assert (!this.finished);
        if (this.finished || this.yieldedCount >= this.query.getLimit()) {
            this.finished = true;
            return;
        }
        while (!this.pendingQueue.isEmpty() || !this.nearestQueue.isEmpty()) {
            if (this.prepareNextNearest()) {
                return;
            }
            assert (!this.pendingQueue.isEmpty());
            ItemWithDistances<AbstractNode<T>> pending = this.pendingQueue.poll();
            AbstractNode node = (AbstractNode)pending.item;
            for (IndexItem child : node.getChildren().values()) {
                double childDistance;
                double childMinDistance;
                if (!(Math.abs(pending.distance - child.getDistanceToParent()) - child.getRadius() <= this.query.getRange()) || !((childMinDistance = Math.max((childDistance = this.query.getMTree().getDistanceFunction().calculate(this.query.getData(), child.getData())) - child.getRadius(), 0.0)) <= this.query.getRange())) continue;
                if (child instanceof Entry) {
                    Entry entry = (Entry)child;
                    this.nearestQueue.add(new ItemWithDistances<Entry>(entry, childDistance, childMinDistance));
                    continue;
                }
                AbstractNode childNode = (AbstractNode)child;
                this.pendingQueue.add(new ItemWithDistances<AbstractNode>(childNode, childDistance, childMinDistance));
            }
            if (this.pendingQueue.isEmpty()) {
                this.nextPendingMinDistance = Double.POSITIVE_INFINITY;
                continue;
            }
            this.nextPendingMinDistance = this.pendingQueue.peek().minDistance;
        }
        this.finished = true;
    }

    private boolean prepareNextNearest() {
        if (!this.nearestQueue.isEmpty()) {
            ItemWithDistances<Entry<T>> nextNearest = this.nearestQueue.peek();
            if (nextNearest.distance <= this.nextPendingMinDistance) {
                this.nearestQueue.poll();
                this.nextResultItem = new ResultItem(((Entry)nextNearest.item).getData(), nextNearest.distance);
                ++this.yieldedCount;
                return true;
            }
        }
        return false;
    }

    private class ItemWithDistances<U>
    implements Comparable<ItemWithDistances<U>> {
        private final U item;
        private final double distance;
        private final double minDistance;

        public ItemWithDistances(U item, double distance, double minDistance) {
            this.item = item;
            this.distance = distance;
            this.minDistance = minDistance;
        }

        @Override
        public int compareTo(ItemWithDistances<U> that) {
            if (this.minDistance < that.minDistance) {
                return -1;
            }
            if (this.minDistance > that.minDistance) {
                return 1;
            }
            return 0;
        }
    }
}

