/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.clustering.mtree.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import kieker.analysis.generic.clustering.mtree.utils.Pair;

public final class MTreeUtils {
    private MTreeUtils() {
    }

    public static <T extends Comparable<T>> Pair<T> minMax(Iterable<T> items) {
        Comparable min;
        Iterator<T> iterator = items.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        Comparable max = min = (Comparable)iterator.next();
        while (iterator.hasNext()) {
            Comparable item = (Comparable)iterator.next();
            if (item.compareTo(min) < 0) {
                min = item;
            }
            if (item.compareTo(max) <= 0) continue;
            max = item;
        }
        return new Pair<Comparable>(min, max);
    }

    public static <T> List<T> randomSample(Collection<T> collection, int numberOfElements) {
        ArrayList<T> list = new ArrayList<T>(collection);
        ArrayList sample = new ArrayList(numberOfElements);
        Random random = new Random();
        for (int count = numberOfElements; count > 0 && !list.isEmpty(); --count) {
            int index = random.nextInt(list.size());
            sample.add(list.get(index));
            int indexLast = list.size() - 1;
            Object last = list.remove(indexLast);
            if (index >= indexLast) continue;
            list.set(index, last);
        }
        return sample;
    }
}

