/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.clustering.optics;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import kieker.analysis.generic.clustering.mtree.MTree;
import kieker.analysis.generic.clustering.mtree.query.Query;
import kieker.analysis.generic.clustering.mtree.query.ResultItem;
import kieker.analysis.generic.clustering.optics.OpticsData;

public class OPTICS<T> {
    private final Comparator<OpticsData<T>> reachComparator = new Comparator<OpticsData<T>>(){

        @Override
        public int compare(OpticsData<T> model1, OpticsData<T> model2) {
            return (int)(model1.getReachabilityDistance() - model2.getReachabilityDistance());
        }
    };
    private final int minPTs;
    private final double maxDistance;
    private final MTree<OpticsData<T>> mtree;
    private final List<OpticsData<T>> models;
    private final List<OpticsData<T>> resultList = new ArrayList<OpticsData<T>>();

    public OPTICS(MTree<OpticsData<T>> mtree, double maxDistance, int minPTs, List<OpticsData<T>> models) {
        this.mtree = mtree;
        this.maxDistance = maxDistance;
        this.minPTs = minPTs;
        this.models = models;
    }

    private double reachabilityDistance(OpticsData<T> model1, OpticsData<T> model2) {
        double coreDistance = model1.getCoreDistance();
        if (coreDistance == -1.0) {
            return -1.0;
        }
        double distance = model1.distanceTo(model2);
        return Math.max(distance, coreDistance);
    }

    private void updateCoreDistance(OpticsData<T> model) {
        int resultAmount = 0;
        OpticsData<T> last = null;
        Query<OpticsData<T>> v = this.getMtree().getNearest(model, this.getMaxDistance(), this.getMinPTs());
        for (ResultItem<OpticsData<T>> resultItem : v) {
            ++resultAmount;
            last = resultItem.getData();
        }
        if (resultAmount < this.getMinPTs()) {
            model.setCoreDistance(-1.0);
        } else {
            model.setCoreDistance(model.distanceTo(last));
        }
    }

    private List<OpticsData<T>> getNeighbors(OpticsData<T> model) {
        Query<OpticsData<T>> query = this.mtree.getNearestByRange(model, this.maxDistance);
        ArrayList<OpticsData<T>> neighbors = new ArrayList<OpticsData<T>>();
        for (ResultItem<OpticsData<T>> resultItem : query) {
            neighbors.add(resultItem.getData());
        }
        return neighbors;
    }

    public List<OpticsData<T>> calculate() {
        for (OpticsData<T> model : this.models) {
            if (model.isVisited()) continue;
            this.expandClusterOrder(model);
        }
        return this.resultList;
    }

    private void update(List<OpticsData<T>> neighbors, OpticsData<T> centerModel, PriorityQueue<OpticsData<T>> seeds) {
        for (OpticsData<T> model : neighbors) {
            if (model.isVisited()) continue;
            double newReachDistance = this.reachabilityDistance(centerModel, model);
            if (model.getReachabilityDistance() == -1.0) {
                model.setReachabilityDistance(newReachDistance);
                seeds.add(model);
                continue;
            }
            if (!(newReachDistance < model.getReachabilityDistance())) continue;
            model.setReachabilityDistance(newReachDistance);
            seeds.remove(model);
            seeds.add(model);
        }
    }

    private void expandClusterOrder(OpticsData<T> model1) {
        List<OpticsData<T>> neighbors1 = this.getNeighbors(model1);
        model1.setVisited(true);
        model1.setReachabilityDistance(-1.0);
        this.updateCoreDistance(model1);
        this.resultList.add(model1);
        if (model1.getCoreDistance() != -1.0) {
            PriorityQueue<OpticsData<T>> seeds = new PriorityQueue<OpticsData<T>>(5, this.reachComparator);
            this.update(neighbors1, model1, seeds);
            while (!seeds.isEmpty()) {
                OpticsData<T> model2 = seeds.poll();
                List<OpticsData<T>> neighbors2 = this.getNeighbors(model2);
                this.updateCoreDistance(model2);
                model2.setVisited(true);
                this.resultList.add(model2);
                if (model2.getCoreDistance() == -1.0) continue;
                this.update(neighbors2, model2, seeds);
            }
        }
    }

    public int getMinPTs() {
        return this.minPTs;
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    public MTree<OpticsData<T>> getMtree() {
        return this.mtree;
    }
}

