/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.clustering.optics;

import kieker.analysis.generic.graph.clustering.OPTICSDataGED;

public class OpticsData<T> {
    public static final int UNDEFINED = -1;
    private final OPTICSDataGED<T> ged;
    private double reachabilityDistance = -1.0;
    private double coreDistance = -1.0;
    private boolean visited = false;
    private final T data;

    public OpticsData(T data, OPTICSDataGED<T> ged) {
        this.data = data;
        this.ged = ged;
    }

    public double getCoreDistance() {
        return this.coreDistance;
    }

    public double distanceTo(OpticsData<T> model) {
        return this.ged.calculate(this, model);
    }

    public void setCoreDistance(double coreDistance) {
        this.coreDistance = coreDistance;
    }

    public double getReachabilityDistance() {
        return this.reachabilityDistance;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public T getData() {
        return this.data;
    }

    public void setVisited(boolean visited) {
        this.visited = visited;
    }

    public void setReachabilityDistance(double reachabilityDistance) {
        this.reachabilityDistance = reachabilityDistance;
    }

    public void reset() {
        this.reachabilityDistance = -1.0;
        this.coreDistance = -1.0;
        this.visited = false;
    }
}

