/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.clustering.optics;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import kieker.analysis.generic.clustering.mtree.MTree;
import kieker.analysis.generic.clustering.optics.OPTICS;
import kieker.analysis.generic.clustering.optics.OpticsData;
import teetime.framework.AbstractStage;
import teetime.framework.InputPort;
import teetime.framework.OutputPort;

public class OpticsStage<T>
extends AbstractStage {
    private final OutputPort<List<OpticsData<T>>> outputPort = this.createOutputPort();
    private final InputPort<MTree<OpticsData<T>>> mTreeInputPort = this.createInputPort();
    private final InputPort<List<OpticsData<T>>> modelsInputPort = this.createInputPort();
    private final Queue<MTree<OpticsData<T>>> mTreeInputQueue = new LinkedList<MTree<OpticsData<T>>>();
    private final Queue<List<OpticsData<T>>> modelsInputQueue = new LinkedList<List<OpticsData<T>>>();
    private final double epsilon;
    private final int minPTs;

    public OpticsStage(double epsilon, int minPTs) {
        this.minPTs = minPTs;
        this.epsilon = epsilon;
    }

    protected void execute() throws Exception {
        MTree newMTree = (MTree)this.mTreeInputPort.receive();
        List newModels = (List)this.modelsInputPort.receive();
        if (newMTree != null) {
            this.mTreeInputQueue.add(newMTree);
        }
        if (newModels != null) {
            this.modelsInputQueue.add(newModels);
        }
        if (!this.mTreeInputQueue.isEmpty() && !this.modelsInputQueue.isEmpty()) {
            this.logger.debug("received models and mtrees, begins to calculate optics result");
            MTree<OpticsData<T>> mtree = this.mTreeInputQueue.poll();
            List<OpticsData<T>> models = this.modelsInputQueue.poll();
            OPTICS<T> optics = new OPTICS<T>(mtree, this.epsilon, this.minPTs, models);
            List<OpticsData<T>> result = optics.calculate();
            this.logger.debug("Send optics results {}", (Object)result.size());
            this.outputPort.send(result);
        }
    }

    public OutputPort<List<OpticsData<T>>> getOutputPort() {
        return this.outputPort;
    }

    public InputPort<MTree<OpticsData<T>>> getMTreeInputPort() {
        return this.mTreeInputPort;
    }

    public InputPort<List<OpticsData<T>>> getModelsInputPort() {
        return this.modelsInputPort;
    }
}

