/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.graph;

import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import kieker.analysis.generic.graph.IEdge;
import kieker.analysis.generic.graph.IGraph;
import kieker.analysis.generic.graph.INode;
import kieker.analysis.generic.graph.impl.EdgeImpl;
import kieker.analysis.generic.graph.impl.GraphImpl;
import kieker.analysis.generic.graph.impl.NodeImpl;

public final class GraphFactory {
    private GraphFactory() {
    }

    public static <N extends INode, E extends IEdge> IGraph<N, E> createGraph(String id, MutableNetwork<N, E> graph) {
        return new GraphImpl<N, E>(id, graph);
    }

    public static <N extends INode, E extends IEdge> IGraph<N, E> createGraph(String name) {
        MutableNetwork graph = NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(true).build();
        return GraphFactory.createGraph(name, graph);
    }

    public static INode createNode(String id) {
        return new NodeImpl(id);
    }

    public static IEdge createEdge(String id) {
        return new EdgeImpl(id);
    }
}

