/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.graph.clustering;

import com.google.common.graph.MutableNetwork;
import java.util.Optional;
import kieker.analysis.generic.clustering.mtree.IDistanceFunction;
import kieker.analysis.generic.graph.IEdge;
import kieker.analysis.generic.graph.INode;
import kieker.analysis.generic.graph.clustering.BasicCostFunction;

public class GraphEditDistance<N extends INode, E extends IEdge>
implements IDistanceFunction<MutableNetwork<N, E>> {
    private final BasicCostFunction<N, E> costFunction;

    public GraphEditDistance(BasicCostFunction<N, E> costFunction) {
        this.costFunction = costFunction;
    }

    @Override
    public double calculate(MutableNetwork<N, E> modelA, MutableNetwork<N, E> modelB) {
        Optional<N> match;
        double distance = 0.0;
        for (INode node : modelA.nodes()) {
            match = this.findNode(modelB, node.getId());
            if (!match.isPresent()) {
                distance += this.nodeInsertionCost(modelA, node);
                continue;
            }
            distance += this.nodeDistance(modelA, node, modelB, (INode)match.get());
        }
        for (INode node : modelB.nodes()) {
            match = this.findNode(modelA, node.getId());
            if (match.isPresent()) continue;
            distance += this.nodeInsertionCost(modelB, node);
        }
        return distance;
    }

    private Optional<N> findNode(MutableNetwork<N, E> model, String signature) {
        return model.nodes().stream().filter(node -> node.getId().equals(signature)).findFirst();
    }

    private double nodeDistance(MutableNetwork<N, E> modelA, N nodeA, MutableNetwork<N, E> modelB, N nodeB) {
        Optional<E> match;
        double distance = this.costFunction.nodeAnnotationDistance(nodeA, nodeB);
        for (IEdge edge : modelA.inEdges(nodeA)) {
            INode sourceA = (INode)modelA.incidentNodes((Object)edge).source();
            INode sourceB = (INode)this.findNode(modelB, sourceA.getId()).get();
            match = this.findEdge(modelB, sourceB, nodeB);
            if (match.isPresent()) {
                distance += this.costFunction.edgeAnnotationDistance(edge, (IEdge)match.get());
                continue;
            }
            distance += this.costFunction.computeEdgeInsertionCost(edge);
        }
        for (IEdge edge : modelB.inEdges(nodeB)) {
            INode sourceB = (INode)modelB.incidentNodes((Object)edge).source();
            INode sourceA = (INode)this.findNode(modelA, sourceB.getId()).get();
            match = this.findEdge(modelA, sourceA, nodeA);
            if (match.isPresent()) continue;
            distance += this.costFunction.computeEdgeInsertionCost(edge);
        }
        return distance;
    }

    private Optional<E> findEdge(MutableNetwork<N, E> model, N source, N target) {
        return model.inEdges(target).stream().filter(edge -> ((INode)model.incidentNodes(edge).source()).equals(source)).findFirst();
    }

    private double nodeInsertionCost(MutableNetwork<N, E> model, N node) {
        double distance = this.costFunction.computeNodeInsertionCost(node);
        for (IEdge edge : model.inEdges(node)) {
            distance += this.costFunction.computeEdgeInsertionCost(edge);
        }
        return distance;
    }
}

