/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.graph.impl;

import com.google.common.graph.MutableNetwork;
import java.util.Optional;
import kieker.analysis.generic.graph.IEdge;
import kieker.analysis.generic.graph.IGraph;
import kieker.analysis.generic.graph.INode;

public class GraphImpl<N extends INode, E extends IEdge>
implements IGraph<N, E> {
    private final MutableNetwork<N, E> graph;
    private String label;

    public GraphImpl(String label, MutableNetwork<N, E> graph) {
        this.label = label;
        this.graph = graph;
    }

    @Override
    public MutableNetwork<N, E> getGraph() {
        return this.graph;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public Optional<N> findNode(String id) {
        return this.graph.nodes().stream().filter(node -> id.equals(node.getId())).findFirst();
    }

    @Override
    public Optional<E> findEdge(String id) {
        return this.graph.edges().stream().filter(edge -> id.equals(edge.getId())).findFirst();
    }
}

