/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.graph.mapping;

import java.nio.file.Path;
import java.util.function.Function;
import kieker.analysis.generic.graph.IEdge;
import kieker.analysis.generic.graph.IGraph;
import kieker.analysis.generic.graph.INode;

public class SimpleFileNameMapper<N extends INode, E extends IEdge>
implements Function<IGraph<N, E>, Path> {
    private final Path outputDirectory;
    private final String fileExtension;

    public SimpleFileNameMapper(Path outputDirectory, String fileExtension) {
        this.outputDirectory = outputDirectory;
        this.fileExtension = fileExtension;
    }

    @Override
    public Path apply(IGraph<N, E> graph) {
        return this.outputDirectory.resolve(String.format("%s.%s", graph.getLabel(), this.fileExtension));
    }
}

