/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.graph.selector;

import java.util.Arrays;
import java.util.List;
import kieker.analysis.architecture.repository.ModelRepository;
import kieker.analysis.exception.InternalErrorException;
import kieker.analysis.generic.graph.IGraphElementSelector;
import kieker.model.analysismodel.execution.Invocation;
import kieker.model.analysismodel.execution.OperationDataflow;
import kieker.model.analysismodel.execution.StorageDataflow;
import kieker.model.analysismodel.source.SourceModel;
import kieker.model.analysismodel.source.SourcePackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class DiffSelector
implements IGraphElementSelector {
    private SourceModel sourceModel;
    private final List<String> groupA;
    private final List<String> groupB;
    private String filePrefix;

    public DiffSelector(String[] groupA, String[] groupB) {
        this.groupA = Arrays.asList(groupA);
        this.groupB = Arrays.asList(groupB);
        this.filePrefix = "diff";
        for (String partition : groupA) {
            this.filePrefix = this.filePrefix + "-" + partition;
        }
        for (String partition : groupB) {
            this.filePrefix = this.filePrefix + "-" + partition;
        }
    }

    @Override
    public void setRepository(ModelRepository repository) throws InternalErrorException {
        this.sourceModel = (SourceModel)repository.getModel(SourcePackage.Literals.SOURCE_MODEL);
        if (this.sourceModel == null) {
            throw new InternalErrorException("Missing source model.");
        }
    }

    @Override
    public boolean nodeIsSelected(EObject value) {
        EList sources = (EList)this.sourceModel.getSources().get((Object)value);
        return this.isSelected((EList<String>)sources);
    }

    @Override
    public boolean edgeIsSelected(Invocation value) {
        EList sources = (EList)this.sourceModel.getSources().get((Object)value);
        return this.isSelected((EList<String>)sources);
    }

    @Override
    public boolean edgeIsSelected(OperationDataflow value) {
        EList sources = (EList)this.sourceModel.getSources().get((Object)value);
        return this.isSelected((EList<String>)sources);
    }

    @Override
    public boolean edgeIsSelected(StorageDataflow value) {
        EList sources = (EList)this.sourceModel.getSources().get((Object)value);
        return this.isSelected((EList<String>)sources);
    }

    private boolean isSelected(EList<String> sources) {
        return this.isGroupSelected(sources, this.groupA) || this.isGroupSelected(sources, this.groupB);
    }

    @Override
    public String getFilePrefix() {
        return this.filePrefix;
    }

    @Override
    public boolean isColorGroup(EList<String> sources, int group) {
        if (group == 0) {
            return this.isGroupSelected(sources, this.groupA) && this.isGroupSelected(sources, this.groupB);
        }
        if (group == 1) {
            return this.isGroupSelected(sources, this.groupA);
        }
        if (group == 2) {
            return this.isGroupSelected(sources, this.groupB);
        }
        return false;
    }

    private boolean isGroupSelected(EList<String> sources, List<String> group) {
        return sources.size() == group.size() && sources.stream().allMatch(source -> group.stream().anyMatch(element -> element.equals(source)));
    }
}

