/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.graph.selector;

import java.util.Arrays;
import java.util.List;
import kieker.analysis.architecture.repository.ModelRepository;
import kieker.analysis.generic.graph.IGraphElementSelector;
import kieker.model.analysismodel.execution.Invocation;
import kieker.model.analysismodel.execution.OperationDataflow;
import kieker.model.analysismodel.execution.StorageDataflow;
import kieker.model.analysismodel.source.SourceModel;
import kieker.model.analysismodel.source.SourcePackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class SubtractSelector
implements IGraphElementSelector {
    private SourceModel sourceModel;
    private final List<String> partitions;
    private String filePrefix;

    public SubtractSelector(String[] partitions) {
        this.partitions = Arrays.asList(partitions);
        this.filePrefix = "subtract";
        for (String partition : partitions) {
            this.filePrefix = this.filePrefix + "-" + partition;
        }
    }

    @Override
    public void setRepository(ModelRepository repository) {
        this.sourceModel = (SourceModel)repository.getModel(SourcePackage.Literals.SOURCE_MODEL);
    }

    @Override
    public boolean nodeIsSelected(EObject value) {
        EList sources = (EList)this.sourceModel.getSources().get((Object)value);
        return this.isSelected((EList<String>)sources);
    }

    @Override
    public boolean edgeIsSelected(Invocation value) {
        EList sources = (EList)this.sourceModel.getSources().get((Object)value);
        return this.isSelected((EList<String>)sources);
    }

    @Override
    public boolean edgeIsSelected(OperationDataflow value) {
        EList sources = (EList)this.sourceModel.getSources().get((Object)value);
        return this.isSelected((EList<String>)sources);
    }

    @Override
    public boolean edgeIsSelected(StorageDataflow value) {
        EList sources = (EList)this.sourceModel.getSources().get((Object)value);
        return this.isSelected((EList<String>)sources);
    }

    private boolean isSelected(EList<String> sources) {
        return sources.size() == this.partitions.size() && sources.stream().allMatch(source -> this.partitions.stream().anyMatch(element -> element.equals(source)));
    }

    @Override
    public String getFilePrefix() {
        return this.filePrefix;
    }

    @Override
    public boolean isColorGroup(EList<String> sources, int group) {
        if (group == 0) {
            return this.isGroupSelected(sources, this.partitions);
        }
        return false;
    }

    private boolean isGroupSelected(EList<String> sources, List<String> group) {
        return sources.size() == group.size() && sources.stream().allMatch(source -> group.stream().anyMatch(element -> element.equals(source)));
    }
}

