/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.graph.traversal;

import com.google.common.graph.MutableNetwork;
import java.util.ArrayList;
import java.util.List;
import kieker.analysis.generic.graph.IEdge;
import kieker.analysis.generic.graph.INode;
import kieker.analysis.generic.graph.traversal.IEdgeVisitor;
import kieker.analysis.generic.graph.traversal.INodeVisitor;

public abstract class AbstractGraphTraverser<N extends INode, E extends IEdge> {
    protected List<INodeVisitor<N>> nodeVisitors;
    protected List<IEdgeVisitor<E>> edgeVisitors;

    public AbstractGraphTraverser() {
        this.nodeVisitors = new ArrayList<INodeVisitor<N>>();
        this.edgeVisitors = new ArrayList<IEdgeVisitor<E>>();
    }

    public AbstractGraphTraverser(INodeVisitor<N> nodeVisitor, IEdgeVisitor<E> edgeVisitor) {
        this();
        this.nodeVisitors.add(nodeVisitor);
        this.edgeVisitors.add(edgeVisitor);
    }

    public AbstractGraphTraverser(List<INodeVisitor<N>> nodeVisitors, List<IEdgeVisitor<E>> edgeVisitors) {
        this.nodeVisitors = nodeVisitors;
        this.edgeVisitors = edgeVisitors;
    }

    public List<INodeVisitor<N>> getNodeVisitors() {
        return this.nodeVisitors;
    }

    public void setNodeVisitors(List<INodeVisitor<N>> nodeVisitors) {
        this.nodeVisitors = nodeVisitors;
    }

    public void addNodeVisitor(INodeVisitor<N> nodeVisitor) {
        this.nodeVisitors.add(nodeVisitor);
    }

    public List<IEdgeVisitor<E>> getEdgeVisitors() {
        return this.edgeVisitors;
    }

    public void setEdgeVisitors(List<IEdgeVisitor<E>> edgeVisitors) {
        this.edgeVisitors = edgeVisitors;
    }

    public void addEdgeVisitor(IEdgeVisitor<E> edgeVisitor) {
        this.edgeVisitors.add(edgeVisitor);
    }

    public abstract void traverse(MutableNetwork<N, E> var1);
}

