/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.graph.traversal;

import com.google.common.graph.MutableNetwork;
import java.util.List;
import kieker.analysis.generic.graph.IEdge;
import kieker.analysis.generic.graph.INode;
import kieker.analysis.generic.graph.traversal.AbstractGraphTraverser;
import kieker.analysis.generic.graph.traversal.IEdgeVisitor;
import kieker.analysis.generic.graph.traversal.INodeVisitor;

public class DeepGraphTraverser<N extends INode, E extends IEdge>
extends AbstractGraphTraverser<N, E> {
    public DeepGraphTraverser() {
    }

    public DeepGraphTraverser(List<INodeVisitor<N>> nodeVisitors, List<IEdgeVisitor<E>> edgeVisitors) {
        super(nodeVisitors, edgeVisitors);
    }

    public DeepGraphTraverser(INodeVisitor<N> nodeVisitor, IEdgeVisitor<E> edgeVisitor) {
        super(nodeVisitor, edgeVisitor);
    }

    @Override
    public void traverse(MutableNetwork<N, E> graph) {
        for (INode node : graph.nodes()) {
            for (Object visitor : this.nodeVisitors) {
                visitor.visitNode(node);
            }
            if (node.getChildGraph() == null) continue;
            this.traverse(node.getChildGraph().getGraph());
        }
        for (IEdge edge : graph.edges()) {
            for (Object visitor : this.edgeVisitors) {
                visitor.visitEdge(edge);
            }
        }
    }
}

