/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.sink;

import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import teetime.framework.AbstractConsumerStage;

public class DataSink
extends AbstractConsumerStage<IMonitoringRecord> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSink.class);
    private final IMonitoringController ctrl;
    private long count;

    public DataSink(Configuration configuration) {
        LOGGER.debug("Configuration complete.");
        this.ctrl = MonitoringController.createInstance(configuration);
    }

    protected void execute(IMonitoringRecord record) {
        ++this.count;
        this.ctrl.newMonitoringRecord(record);
        if (this.count % 100000L == 0L) {
            LOGGER.info("Saved {} records.", (Object)this.count);
        }
    }

    public long getCount() {
        return this.count;
    }
}

