/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.sink;

import java.io.IOException;
import java.io.Writer;

public class IndentWriter
extends Writer {
    public static final char DEFAULT_INDENT_CHAR = '\t';
    public static final int DEFAULT_INDENT_LENGTH = 1;
    private final Writer writer;
    private int indented;
    private char indentChar = (char)9;
    private int indentLength = 1;

    public IndentWriter(Writer writer) {
        this.writer = writer;
    }

    public IndentWriter(Writer writer, char indentChar, int indentLength) {
        this(writer);
        this.indentChar = indentChar;
        this.indentLength = indentLength;
    }

    public void indent() {
        ++this.indented;
    }

    public void unindent() {
        if (this.indented > 0) {
            --this.indented;
        }
    }

    public void writeln(String str) throws IOException {
        this.writer.write(this.getIndentChars() + str + "\n");
    }

    private String getIndentChars() {
        return new String(new char[this.indented * this.indentLength]).replace('\u0000', this.indentChar);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

