/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.sink;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kieker.analysis.generic.Table;
import org.csveed.api.CsvClientImpl;
import teetime.framework.AbstractConsumerStage;

public class SingleFileTableCsvSink<R, T>
extends AbstractConsumerStage<Table<R, T>> {
    public static final char[] LF = new char[]{'\n'};
    public static final char[] CRLF = new char[]{'\r', '\n'};
    public static final char[] CR = new char[]{'\r'};
    private final boolean header;
    private final Class<T> clazz;
    private final char[] newline;
    private final Path path;

    public SingleFileTableCsvSink(Path path, Class<T> clazz, boolean header, char[] newline) {
        this.header = header;
        this.path = path;
        this.clazz = clazz;
        this.newline = newline;
    }

    protected void execute(Table<R, T> table) throws IOException {
        try (BufferedWriter outputStream = Files.newBufferedWriter(this.path, StandardCharsets.UTF_8, new OpenOption[0]);){
            CsvClientImpl csvClient = new CsvClientImpl((Writer)outputStream, this.clazz);
            csvClient.setEndOfLine(this.newline);
            csvClient.setUseHeader(this.header);
            csvClient.writeBeans(table.getRows());
            outputStream.close();
        }
    }
}

