/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.sink;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Function;
import kieker.analysis.generic.Table;
import org.csveed.api.CsvClientImpl;
import teetime.framework.AbstractConsumerStage;

public class TableCsvSink<R, T>
extends AbstractConsumerStage<Table<R, T>> {
    public static final char[] LF = new char[]{'\n'};
    public static final char[] CRLF = new char[]{'\r', '\n'};
    public static final char[] CR = new char[]{'\r'};
    private final Function<String, Path> filePathFunction;
    private final boolean header;
    private Class<T> clazz;
    private char[] newline;

    public TableCsvSink(Function<String, Path> filePathFunction, Class<T> clazz, boolean header, char[] newline) {
        this.header = header;
        this.filePathFunction = filePathFunction;
        this.clazz = clazz;
        this.newline = newline;
    }

    public TableCsvSink(final Path filePath, final String filename, Class<T> clazz, boolean header, char[] newline) {
        this(new Function<String, Path>(){

            @Override
            public Path apply(String name) {
                return filePath.resolve(String.format("%s-%s", name, filename));
            }
        }, clazz, header, newline);
    }

    public TableCsvSink(final Path filePath, Class<T> clazz, boolean header, char[] newline) {
        this(new Function<String, Path>(){

            @Override
            public Path apply(String name) {
                return filePath.resolve(String.format("%s.csv", name));
            }
        }, clazz, header, newline);
    }

    protected void execute(Table<R, T> table) throws IOException {
        try (BufferedWriter outputStream = Files.newBufferedWriter(this.filePathFunction.apply(table.getLabel().toString()), StandardCharsets.UTF_8, new OpenOption[0]);){
            CsvClientImpl csvClient = new CsvClientImpl((Writer)outputStream, this.clazz);
            csvClient.setEndOfLine(this.newline);
            csvClient.setUseHeader(this.header);
            csvClient.writeBeans(table.getRows());
            outputStream.close();
        }
    }
}

