/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.sink.graph;

import com.google.common.graph.MutableNetwork;
import kieker.analysis.generic.graph.GraphFactory;
import kieker.analysis.generic.graph.IEdge;
import kieker.analysis.generic.graph.IGraph;
import kieker.analysis.generic.graph.INode;
import kieker.analysis.generic.graph.traversal.AbstractGraphTraverser;
import kieker.analysis.generic.graph.traversal.FlatGraphTraverser;
import kieker.analysis.generic.graph.traversal.IEdgeVisitor;
import kieker.analysis.generic.graph.traversal.INodeVisitor;

public abstract class AbstractTransformer<O, N extends INode, E extends IEdge>
implements INodeVisitor<N>,
IEdgeVisitor<E> {
    protected IGraph<N, E> graph;
    private final AbstractGraphTraverser<N, E> graphTraverser = new FlatGraphTraverser(this, this);

    protected AbstractTransformer(IGraph<N, E> graph) {
        this.graph = graph;
    }

    protected AbstractTransformer(MutableNetwork<N, E> graph, String label) {
        this.graph = GraphFactory.createGraph(label, graph);
    }

    public final O transform() {
        this.beforeTransformation();
        this.graphTraverser.traverse(this.graph.getGraph());
        this.afterTransformation();
        return this.getTransformation();
    }

    protected abstract void beforeTransformation();

    protected abstract void afterTransformation();

    protected abstract void transformVertex(N var1);

    protected abstract void transformEdge(E var1);

    protected abstract O getTransformation();

    @Override
    public void visitNode(N vertex) {
        this.transformVertex(vertex);
    }

    @Override
    public void visitEdge(E edge) {
        this.transformEdge(edge);
    }
}

