/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.sink.graph.blueprints;

import com.google.common.graph.EndpointPair;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.tg.TinkerGraph;
import java.util.HashMap;
import java.util.Map;
import kieker.analysis.generic.graph.IEdge;
import kieker.analysis.generic.graph.IGraph;
import kieker.analysis.generic.graph.INode;
import kieker.analysis.generic.sink.graph.AbstractTransformer;

public class BlueprintsTransformer<N extends INode, E extends IEdge>
extends AbstractTransformer<Graph, N, E> {
    private static final String LABEL_PROPERTY = "label";
    private final Graph transformedGraph = new TinkerGraph();
    private final Map<INode, Vertex> mappedVertices = new HashMap<INode, Vertex>();

    public BlueprintsTransformer(IGraph<N, E> graph) {
        super(graph);
    }

    @Override
    protected void transformVertex(N vertex) {
        Vertex mappedVertex = this.transformedGraph.addVertex((Object)vertex.getId());
        this.mappedVertices.put((INode)vertex, mappedVertex);
        for (String propertyKey : vertex.getPropertyKeys()) {
            mappedVertex.setProperty(propertyKey, vertex.getProperty(propertyKey));
        }
    }

    @Override
    protected void transformEdge(E edge) {
        EndpointPair pair = this.graph.getGraph().incidentNodes(edge);
        Vertex mappedInVertex = this.mappedVertices.get(pair.target());
        Vertex mappedOutVertex = this.mappedVertices.get(pair.source());
        String label = (String)edge.getProperty(LABEL_PROPERTY);
        if (label == null) {
            label = "";
        }
        Edge mappedEdge = this.transformedGraph.addEdge((Object)edge.getId(), mappedOutVertex, mappedInVertex, label);
        for (String propertyKey : edge.getPropertyKeys()) {
            mappedEdge.setProperty(propertyKey, edge.getProperty(propertyKey));
        }
    }

    @Override
    protected Graph getTransformation() {
        return this.transformedGraph;
    }

    @Override
    protected void beforeTransformation() {
    }

    @Override
    protected void afterTransformation() {
    }
}

