/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.sink.graph.dot;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.MutableNetwork;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import kieker.analysis.generic.graph.IEdge;
import kieker.analysis.generic.graph.IGraph;
import kieker.analysis.generic.graph.INode;
import kieker.analysis.generic.sink.graph.AbstractTransformer;
import kieker.analysis.generic.sink.graph.dot.DotExportMapper;
import kieker.analysis.generic.sink.graph.dot.DotGraphWriter;
import kieker.analysis.generic.sink.graph.dot.attributes.DotClusterAttribute;
import kieker.analysis.generic.sink.graph.dot.attributes.DotEdgeAttribute;
import kieker.analysis.generic.sink.graph.dot.attributes.DotNodeAttribute;

class DotElementTransformer<N extends INode, E extends IEdge>
extends AbstractTransformer<Void, N, E> {
    protected final DotGraphWriter dotGraphWriter;
    protected final DotExportMapper<N, E> configuration;

    protected DotElementTransformer(IGraph<N, E> graph, DotGraphWriter dotGraphWriter, DotExportMapper<N, E> configuration) {
        super(graph);
        this.dotGraphWriter = dotGraphWriter;
        this.configuration = configuration;
    }

    protected DotElementTransformer(MutableNetwork<N, E> graph, String label, DotGraphWriter dotGraphWriter, DotExportMapper<N, E> configuration) {
        super(graph, label);
        this.dotGraphWriter = dotGraphWriter;
        this.configuration = configuration;
    }

    @Override
    protected void transformVertex(N vertex) {
        try {
            if (vertex.hasChildGraph()) {
                MutableNetwork childGraph = vertex.getChildGraph().getGraph();
                this.dotGraphWriter.addClusterStart(vertex.getId());
                for (Map.Entry<DotClusterAttribute, Function<N, String>> attribute : this.configuration.getClusterAttributes()) {
                    this.dotGraphWriter.addGraphAttribute(attribute.getKey().toString(), attribute.getValue().apply(vertex));
                }
                DotElementTransformer childGraphWriter = new DotElementTransformer(childGraph, vertex.getId(), this.dotGraphWriter, this.configuration);
                childGraphWriter.transform();
                this.dotGraphWriter.addClusterStop();
            } else {
                this.dotGraphWriter.addNode(vertex.getId(), this.getAttributes(vertex));
            }
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    protected void transformEdge(E edge) {
        try {
            EndpointPair pair = this.graph.getGraph().incidentNodes(edge);
            String sourceId = ((INode)pair.source()).getId();
            String targetId = ((INode)pair.target()).getId();
            this.dotGraphWriter.addEdge(sourceId, targetId, this.getAttributes((N)edge));
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    protected void handleIOException(IOException ioException) {
        throw new IllegalStateException(ioException);
    }

    protected Map<String, String> getAttributes(E edge) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Map.Entry<DotEdgeAttribute, Function<E, String>> entry : this.configuration.getEdgeAttributes()) {
            String value = entry.getValue().apply(edge);
            if (value == null) continue;
            attributes.put(entry.getKey().toString(), value);
        }
        return attributes;
    }

    protected Map<String, String> getAttributes(N vertex) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Map.Entry<DotNodeAttribute, Function<N, String>> entry : this.configuration.getNodeAttributes()) {
            String value = entry.getValue().apply(vertex);
            if (value == null) continue;
            attributes.put(entry.getKey().toString(), value);
        }
        return attributes;
    }

    @Override
    protected void beforeTransformation() {
    }

    @Override
    protected void afterTransformation() {
    }

    @Override
    protected Void getTransformation() {
        return null;
    }
}

