/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.sink.graph.dot;

import com.google.common.graph.MutableNetwork;
import java.util.function.Function;
import kieker.analysis.generic.graph.IEdge;
import kieker.analysis.generic.graph.INode;
import kieker.analysis.generic.sink.graph.dot.DotExportMapper;
import kieker.analysis.generic.sink.graph.dot.attributes.DotClusterAttribute;
import kieker.analysis.generic.sink.graph.dot.attributes.DotEdgeAttribute;
import kieker.analysis.generic.sink.graph.dot.attributes.DotGraphAttribute;
import kieker.analysis.generic.sink.graph.dot.attributes.DotNodeAttribute;

public class DotExportBuilder<N extends INode, E extends IEdge> {
    private final DotExportMapper<N, E> configuration = new DotExportMapper();

    public void addGraphAttribute(DotGraphAttribute attribute, Function<MutableNetwork<N, E>, String> function) {
        this.configuration.graphAttributes.put(attribute, function);
    }

    public void addDefaultNodeAttribute(DotNodeAttribute attribute, Function<MutableNetwork<N, E>, String> function) {
        this.configuration.defaultNodeAttributes.put(attribute, function);
    }

    public void addDefaultEdgeAttribute(DotEdgeAttribute attribute, Function<MutableNetwork<N, E>, String> function) {
        this.configuration.defaultEdgeAttributes.put(attribute, function);
    }

    public void addNodeAttribute(DotNodeAttribute attribute, Function<N, String> function) {
        this.configuration.nodeAttributes.put(attribute, function);
    }

    public void addEdgeAttribute(DotEdgeAttribute attribute, Function<E, String> function) {
        this.configuration.edgeAttributes.put(attribute, function);
    }

    public void addClusterAttribute(DotClusterAttribute attribute, Function<N, String> function) {
        this.configuration.clusterAttributes.put(attribute, function);
    }

    public DotExportMapper<N, E> build() {
        return this.configuration;
    }
}

