/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.sink.graph.dot;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Function;
import kieker.analysis.generic.graph.IEdge;
import kieker.analysis.generic.graph.IGraph;
import kieker.analysis.generic.graph.INode;
import kieker.analysis.generic.graph.mapping.SimpleFileNameMapper;
import kieker.analysis.generic.sink.graph.dot.DotExportMapper;
import kieker.analysis.generic.sink.graph.dot.DotWriterStage;
import kieker.analysis.generic.sink.graph.dot.SimpleDotExportConfiguration;

public class DotFileWriterStage<N extends INode, E extends IEdge>
extends DotWriterStage<N, E> {
    private static final String DOT_EXTENSION = "dot";

    public DotFileWriterStage(Function<IGraph<N, E>, Path> fileNameMapper) {
        this(fileNameMapper, (DotExportMapper<N, E>)new SimpleDotExportConfiguration());
    }

    public DotFileWriterStage(Function<IGraph<N, E>, Path> fileNameMapper, DotExportMapper<N, E> exportConfiguration) {
        super(fileNameMapper.andThen(fileName -> {
            try {
                return Files.newBufferedWriter(fileName, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }), exportConfiguration);
    }

    public DotFileWriterStage(Path outputDirectory) {
        this(outputDirectory, new SimpleDotExportConfiguration());
    }

    public DotFileWriterStage(Path outputDirectory, DotExportMapper<N, E> exportConfiguration) {
        this(new SimpleFileNameMapper(outputDirectory, DOT_EXTENSION), exportConfiguration);
    }
}

