/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.sink.graph.dot;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import kieker.analysis.generic.graph.IEdge;
import kieker.analysis.generic.graph.IGraph;
import kieker.analysis.generic.graph.INode;
import kieker.analysis.generic.sink.graph.dot.DotElementTransformer;
import kieker.analysis.generic.sink.graph.dot.DotExportMapper;
import kieker.analysis.generic.sink.graph.dot.DotGraphWriter;
import kieker.analysis.generic.sink.graph.dot.SimpleDotExportConfiguration;

public class DotTransformer<N extends INode, E extends IEdge>
extends DotElementTransformer<N, E> {
    public DotTransformer(IGraph<N, E> graph, Writer writer) {
        this(graph, writer, new SimpleDotExportConfiguration());
    }

    public DotTransformer(IGraph<N, E> graph, Writer writer, DotExportMapper<N, E> configuration) {
        super(graph, new DotGraphWriter(writer), configuration);
    }

    @Override
    protected void beforeTransformation() {
        try {
            this.dotGraphWriter.start(this.graph.getLabel());
            for (Map.Entry entry : this.configuration.getGraphAttributes()) {
                this.dotGraphWriter.addGraphAttribute(entry.getKey().toString(), entry.getValue().apply(this.graph.getGraph()));
            }
            HashMap<String, String> defaultNodeAttributes = new HashMap<String, String>();
            for (Map.Entry entry : this.configuration.getDefaultNodeAttributes()) {
                defaultNodeAttributes.put(entry.getKey().toString(), entry.getValue().apply(this.graph.getGraph()));
            }
            this.dotGraphWriter.addDefaultNodeAttributes(defaultNodeAttributes);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Map.Entry attribute : this.configuration.getDefaultEdgeAttributes()) {
                hashMap.put(attribute.getKey().toString(), attribute.getValue().apply(this.graph.getGraph()));
            }
            this.dotGraphWriter.addDefaultEdgeAttributes(hashMap);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    protected void afterTransformation() {
        try {
            this.dotGraphWriter.finish();
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }
}

