/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.sink.graph.graphml;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Function;
import kieker.analysis.generic.graph.IEdge;
import kieker.analysis.generic.graph.IGraph;
import kieker.analysis.generic.graph.INode;
import kieker.analysis.generic.graph.mapping.SimpleFileNameMapper;
import kieker.analysis.generic.sink.graph.graphml.GraphMLWriterStage;

public class GraphMLFileWriterStage<N extends INode, E extends IEdge>
extends GraphMLWriterStage<N, E> {
    private static final String GRAPHML = "graphml";

    public GraphMLFileWriterStage(Function<IGraph<N, E>, Path> fileNameMapper) {
        super(fileNameMapper.andThen(fileName -> {
            try {
                return Files.newOutputStream(fileName, StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }));
    }

    public GraphMLFileWriterStage(Path outputDirectory) {
        this(new SimpleFileNameMapper(outputDirectory, GRAPHML));
    }
}

