/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.source;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import org.csveed.api.CsvClient;
import org.csveed.api.CsvClientImpl;
import org.csveed.report.CsvException;
import teetime.framework.AbstractProducerStage;

public class CsvRowReaderProducerStage<T>
extends AbstractProducerStage<T> {
    private final CsvClient<T> csvClient;
    private final BufferedReader reader;
    private final Path path;

    public CsvRowReaderProducerStage(Path path, char separator, char quoteSymbol, char escapeSymbol, boolean header, Class<T> clazz) throws IOException {
        this.path = path;
        this.reader = Files.newBufferedReader(path);
        this.csvClient = new CsvClientImpl((Reader)this.reader, clazz);
        this.csvClient.setQuote(quoteSymbol);
        this.csvClient.setSeparator(separator);
        this.csvClient.setEscape(escapeSymbol);
        this.csvClient.setUseHeader(header);
    }

    protected void execute() throws Exception {
        this.csvClient.skipEmptyLines(true);
        try {
            Object bean;
            while (!this.csvClient.isFinished() && (bean = this.csvClient.readBean()) != null) {
                this.outputPort.send(bean);
            }
            this.reader.close();
        }
        catch (CsvException e) {
            this.logger.error("Error reading csv file in line {} path {}", (Object)this.csvClient.getCurrentLine(), (Object)this.path.toString());
            throw e;
        }
        this.workCompleted();
    }
}

