/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.source;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import kieker.analysis.generic.IPathLabelMapper;
import kieker.analysis.generic.Table;
import org.csveed.api.CsvClient;
import org.csveed.api.CsvClientImpl;
import org.csveed.report.CsvException;
import teetime.framework.AbstractProducerStage;

public class CsvTableReaderProducerStage<R, T>
extends AbstractProducerStage<Table<R, T>> {
    private final CsvClient<T> csvClient;
    private final BufferedReader reader;
    private final Path path;
    private final Table<R, T> table;

    public CsvTableReaderProducerStage(Path path, char separator, char quoteSymbol, char escapeSymbol, boolean header, Class<T> clazz, R label) throws IOException {
        this.path = path;
        this.reader = Files.newBufferedReader(path);
        this.csvClient = new CsvClientImpl((Reader)this.reader, clazz);
        this.csvClient.setQuote(quoteSymbol);
        this.csvClient.setSeparator(separator);
        this.csvClient.setEscape(escapeSymbol);
        this.csvClient.setUseHeader(header);
        this.table = new Table(label);
    }

    public CsvTableReaderProducerStage(Path path, char separator, char quoteSymbol, char escapeSymbol, boolean header, Class<T> clazz, IPathLabelMapper<R> mapper) throws IOException {
        this(path, separator, quoteSymbol, escapeSymbol, header, clazz, mapper.map(path));
    }

    protected void execute() throws Exception {
        this.csvClient.skipEmptyLines(true);
        try {
            Object bean;
            while (!this.csvClient.isFinished() && (bean = this.csvClient.readBean()) != null) {
                this.table.getRows().add(bean);
            }
            this.outputPort.send(this.table);
            this.reader.close();
        }
        catch (CsvException e) {
            this.logger.error("Error reading csv file in line {} path {}", (Object)this.csvClient.getCurrentLine(), (Object)this.path.toString());
            throw e;
        }
        this.workCompleted();
    }
}

