/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.source;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import kieker.analysis.generic.source.IAccessHandler;
import kieker.analysis.generic.source.NetworkPatternEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAccessHandler
implements IAccessHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)NetworkPatternEntry.class.getCanonicalName());
    private static final byte[] BYTE_PATTERNS = new byte[]{0, -128, -64, -32, -16, -8, -4, -2, -1};
    private final Collection<NetworkPatternEntry> patterns = new ArrayList<NetworkPatternEntry>();

    public NetworkAccessHandler(Collection<String> networkPatterns) throws UnknownHostException {
        for (String pattern : networkPatterns) {
            String[] parts = pattern.split("/");
            InetAddress address = InetAddress.getByName(parts[0]);
            int width = parts.length == 2 ? Integer.parseInt(parts[1]) : (address.getAddress().length == 4 ? 32 : 128);
            this.patterns.add(new NetworkPatternEntry(address.getAddress(), this.computeMask(address.getAddress().length, width)));
        }
    }

    private byte[] computeMask(int width, int maskSetBitCount) {
        byte[] mask = new byte[width];
        int remainingBitsToSet = maskSetBitCount;
        int i = 0;
        while (remainingBitsToSet > 8) {
            mask[i] = -1;
            remainingBitsToSet -= 8;
            ++i;
        }
        if (remainingBitsToSet > 0) {
            mask[i] = BYTE_PATTERNS[remainingBitsToSet];
        }
        return mask;
    }

    @Override
    public boolean acceptRemoteIpAddress(String remoteIpAddress) {
        try {
            InetAddress address = InetAddress.getByName(remoteIpAddress);
            for (NetworkPatternEntry entry : this.patterns) {
                byte[] addressMask;
                byte[] patternMask = this.applyMask(entry.getIpAddress(), entry.getMask());
                if (!Arrays.equals(patternMask, addressMask = this.applyMask(address.getAddress(), entry.getMask()))) continue;
                return true;
            }
        }
        catch (UnknownHostException e) {
            LOGGER.error("Ip address or hostname {} is not found.", (Object)remoteIpAddress);
        }
        return false;
    }

    private byte[] applyMask(byte[] address, byte[] mask) {
        if (address.length != mask.length) {
            return new byte[mask.length];
        }
        byte[] result = new byte[address.length];
        for (int i = 0; i < address.length; ++i) {
            result[i] = (byte)(address[i] & mask[i]);
        }
        return result;
    }
}

