/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.source.file;

import java.io.IOException;
import java.io.InputStream;
import java.nio.CharBuffer;
import kieker.analysis.generic.source.file.AbstractEventDeserializer;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.factory.CachedRecordFactoryCatalog;
import kieker.common.record.factory.IRecordFactory;
import kieker.common.record.io.TextValueDeserializer;
import kieker.common.registry.reader.ReaderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import teetime.framework.OutputPort;

public class DatEventDeserializer
extends AbstractEventDeserializer {
    public static final String PREFIX = DatEventDeserializer.class.getCanonicalName() + ".";
    public static final String BUFFER_SIZE = PREFIX + "bufferSize";
    public static final int DEFAULT_BUFFER_SIZE = 102400;
    private static final Logger LOGGER = LoggerFactory.getLogger(DatEventDeserializer.class);
    private final CachedRecordFactoryCatalog recordFactories = CachedRecordFactoryCatalog.getInstance();
    private final CharBuffer charBuffer;
    private long lineNumber;

    public DatEventDeserializer(Integer bufferSize, ReaderRegistry<String> registry) {
        super(registry);
        this.charBuffer = CharBuffer.allocate(bufferSize == null ? 102400 : bufferSize);
    }

    @Override
    public void processDataStream(InputStream inputStream, OutputPort<IMonitoringRecord> outputPort) throws IOException {
        byte[] buffer = new byte[this.charBuffer.length() * 2];
        boolean endOfFile = false;
        int offset = 0;
        this.lineNumber = 0L;
        while (!endOfFile) {
            int numOfReadBytes = inputStream.read(buffer, offset, buffer.length - offset);
            if (numOfReadBytes == -1) {
                endOfFile = true;
                continue;
            }
            int numOfBufferedBytes = numOfReadBytes + offset;
            int mark = this.processBuffer(buffer, offset, numOfBufferedBytes, outputPort);
            for (int j = mark + 1; j < numOfBufferedBytes; ++j) {
                buffer[j - mark - 1] = buffer[j];
            }
            offset = numOfBufferedBytes - mark;
        }
        if (this.charBuffer.position() > 0) {
            this.createRecord(outputPort);
        }
    }

    private int processBuffer(byte[] buffer, int offset, int numOfBufferedBytes, OutputPort<IMonitoringRecord> outputPort) {
        int mark = 0;
        for (int i = offset; i < numOfBufferedBytes; ++i) {
            char ch = (char)buffer[i];
            if (ch == '\n') {
                ++this.lineNumber;
                this.createRecord(outputPort);
                mark = i;
                continue;
            }
            if (ch == '\r') {
                if (i + 1 == numOfBufferedBytes) {
                    return mark;
                }
                if (buffer[i + 1] == 10) {
                    // empty if block
                }
                ++this.lineNumber;
                this.createRecord(outputPort);
                mark = ++i;
                continue;
            }
            this.charBuffer.append(ch);
        }
        return mark;
    }

    private void createRecord(OutputPort<IMonitoringRecord> outputPort) {
        this.charBuffer.flip();
        char lead = this.charBuffer.get();
        if (lead == '$') {
            TextValueDeserializer deserializer = TextValueDeserializer.create(this.charBuffer);
            int id = deserializer.getInt();
            String classname = (String)this.registry.get(id);
            if (classname == null) {
                LOGGER.error("Missing classname mapping for record type id '{}'", (Object)id);
            } else {
                long loggingTimestamp = deserializer.getLong();
                IRecordFactory<? extends IMonitoringRecord> recordFactory = this.recordFactories.get(classname);
                if (recordFactory != null) {
                    IMonitoringRecord event = recordFactory.create(deserializer);
                    event.setLoggingTimestamp(loggingTimestamp);
                    outputPort.send((Object)event);
                } else {
                    LOGGER.error("Record type {} not supported", (Object)classname);
                }
                this.charBuffer.clear();
            }
        } else {
            LOGGER.error("Malformed entry in file at line {}.", (Object)this.lineNumber);
        }
    }
}

