/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.source.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Predicate;
import teetime.stage.basic.AbstractFilter;

public class DirectoryScannerStage
extends AbstractFilter<Path> {
    private final boolean recursive;
    private final Predicate<Path> fileFilter;
    private final Predicate<Path> directoryFilter;

    public DirectoryScannerStage(boolean recursive, Predicate<Path> directoryFilter, Predicate<Path> fileFilter) {
        this.recursive = recursive;
        this.directoryFilter = directoryFilter;
        this.fileFilter = fileFilter;
    }

    protected void execute(Path directory) throws Exception {
        if (this.recursive) {
            Files.walkFileTree(directory, this.createVisitor(directory));
        } else {
            for (File file : directory.toFile().listFiles()) {
                if (!this.fileFilter.test(file.toPath())) continue;
                this.outputPort.send((Object)file.toPath());
            }
        }
    }

    private FileVisitor<? super Path> createVisitor(final Path directory) {
        return new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes attrs) {
                if (!Files.isDirectory(filePath, new LinkOption[0]) && DirectoryScannerStage.this.fileFilter.test(filePath)) {
                    DirectoryScannerStage.this.outputPort.send((Object)filePath);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (dir.equals(directory) || DirectoryScannerStage.this.directoryFilter.test(dir)) {
                    return super.preVisitDirectory(dir, attrs);
                }
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path filePath, IOException exc) {
                DirectoryScannerStage.this.logger.warn("Could not visit {}: ", (Object)filePath.toString(), exc.getClass());
                return FileVisitResult.CONTINUE;
            }
        };
    }
}

