/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.source.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import fi.iki.elonen.NanoHTTPD;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import kieker.analysis.generic.source.IAccessHandler;
import kieker.analysis.generic.source.rest.RestServiceStage;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.factory.CachedRecordFactoryCatalog;
import kieker.common.record.factory.IRecordFactory;
import kieker.common.record.io.JsonArrayValueDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestService
extends NanoHTTPD {
    private static final String KIEKER_PATH = "kieker";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)RestService.class.getCanonicalName());
    private final CachedRecordFactoryCatalog recordFactories = CachedRecordFactoryCatalog.getInstance();
    private final RestServiceStage stage;
    private final IAccessHandler accessHandler;

    public RestService(RestServiceStage stage, String hostname, int port, IAccessHandler accessHandler) {
        super(hostname, port);
        this.stage = stage;
        this.accessHandler = accessHandler;
    }

    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        if (this.accessHandler.acceptRemoteIpAddress(session.getRemoteIpAddress())) {
            NanoHTTPD.Method method = session.getMethod();
            if (NanoHTTPD.Method.PUT.equals((Object)method) || NanoHTTPD.Method.POST.equals((Object)method)) {
                String path = URI.create(session.getUri()).getPath();
                if (KIEKER_PATH.equals(path)) {
                    return this.handlePutRequest(session);
                }
                return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND, (String)"text/plain", (String)("URI path '" + path + "'not recognized"));
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"PUT request expected");
        }
        return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.UNAUTHORIZED, (String)"text/plain", (String)"Access denied");
    }

    private NanoHTTPD.Response handlePutRequest(NanoHTTPD.IHTTPSession session) {
        try {
            Integer size = Integer.valueOf((String)session.getHeaders().get("content-length"));
            if (size != null) {
                byte[] buffer = new byte[size.intValue()];
                InputStream stream = session.getInputStream();
                if (stream.read(buffer, 0, size) == size.intValue()) {
                    String contentType = (String)session.getHeaders().get("content-type");
                    if ("application/json".equals(contentType)) {
                        return this.processJsonRequest(buffer);
                    }
                    return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"JSON data expected");
                }
                return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Corrupted message");
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"JSON data expected");
        }
        catch (IOException e) {
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, (String)"text/plain", (String)"IO exception");
        }
    }

    private NanoHTTPD.Response processJsonRequest(byte[] buffer) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.readTree(buffer);
            JsonNode object = mapper.readTree(buffer);
            if (object.getNodeType() == JsonNodeType.ARRAY) {
                return this.processJsonArray((ArrayNode)object);
            }
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"JSON array expected");
        }
        catch (IOException e) {
            try {
                LOGGER.error("Parsing error for JSON message: {}", (Object)new String(buffer, "UTF-8"));
                return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Malformed JSON data");
            }
            catch (UnsupportedEncodingException e1) {
                return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Malformed JSON data, is not UTF-8");
            }
        }
    }

    private NanoHTTPD.Response processJsonArray(ArrayNode arrayNode) {
        JsonArrayValueDeserializer deserializer = JsonArrayValueDeserializer.create(arrayNode);
        String eventClassName = deserializer.getString();
        IRecordFactory<? extends IMonitoringRecord> recordFactory = this.recordFactories.get(eventClassName);
        try {
            IMonitoringRecord event = recordFactory.create(deserializer);
            this.stage.getOutputPort().send((Object)event);
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.ACCEPTED, (String)"text/plain", (String)"");
        }
        catch (RecordInstantiationException ex) {
            LOGGER.error("Failed to create {}: {}", (Object)eventClassName, (Object)ex.getLocalizedMessage());
            return NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, (String)"text/plain", (String)"Malformed data");
        }
    }
}

