/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.source.time;

import java.util.concurrent.TimeUnit;
import kieker.common.record.misc.TimestampRecord;
import teetime.framework.AbstractProducerStage;
import teetime.framework.OutputPort;

public class TimeReaderStage
extends AbstractProducerStage<Long> {
    private final OutputPort<TimestampRecord> timestampsRecordOutputPort = this.createOutputPort(TimestampRecord.class);
    private final long delay;
    private final TimeUnit timeunit = TimeUnit.NANOSECONDS;
    private long numberOfImpulses;
    private final boolean infinite;

    public TimeReaderStage(long delay, Long numberOfImpulses) {
        this.delay = delay;
        this.numberOfImpulses = numberOfImpulses;
        this.infinite = numberOfImpulses == null;
    }

    protected void execute() throws Exception {
        while (this.repeatEvent()) {
            long timestamp = this.timeunit.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
            this.outputPort.send((Object)timestamp);
            this.timestampsRecordOutputPort.send((Object)new TimestampRecord(timestamp));
            Thread.sleep(this.delay / 1000L / 1000L);
            --this.numberOfImpulses;
        }
        this.workCompleted();
    }

    private boolean repeatEvent() {
        if (this.infinite) {
            return true;
        }
        return this.numberOfImpulses > 0L;
    }

    public OutputPort<TimestampRecord> getTimestampsRecordOutputPort() {
        return this.timestampsRecordOutputPort;
    }
}

