/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.time;

import kieker.analysis.generic.time.AbstractCurrentTimeEventGenerationFilter;
import kieker.common.record.misc.TimestampRecord;

public class TimestampCurrentTimeEventGenerationFilter
extends AbstractCurrentTimeEventGenerationFilter<Long> {
    public TimestampCurrentTimeEventGenerationFilter(long timerResolution) {
        super(timerResolution);
    }

    @Override
    protected void execute(Long timestamp) {
        if (timestamp < 0L) {
            this.logger.warn("Received timestamp value < 0: " + timestamp);
            return;
        }
        if (this.firstTimestamp == -1L) {
            this.maxTimestamp = timestamp;
            this.firstTimestamp = timestamp;
            this.currentTimeRecordOutputPort.send((Object)new TimestampRecord(timestamp));
            this.currentTimeValueOutputPort.send((Object)timestamp);
            this.mostRecentEventFired = timestamp;
        } else if (timestamp > this.maxTimestamp) {
            this.maxTimestamp = timestamp;
            long nextTimerEventAt = this.mostRecentEventFired + this.timerResolution;
            while (timestamp >= nextTimerEventAt) {
                this.currentTimeRecordOutputPort.send((Object)new TimestampRecord(nextTimerEventAt));
                this.currentTimeValueOutputPort.send((Object)nextTimerEventAt);
                this.mostRecentEventFired = nextTimerEventAt;
                nextTimerEventAt = this.mostRecentEventFired + this.timerResolution;
            }
        }
    }
}

