/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.metrics.graph.entropy;

import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.Map;
import java.util.Optional;
import kieker.analysis.architecture.repository.ModelRepository;
import kieker.analysis.exception.InternalErrorException;
import kieker.analysis.generic.graph.EGraphGenerationMode;
import kieker.analysis.generic.graph.IGraphElementSelector;
import kieker.analysis.metrics.graph.entropy.KiekerNode;
import kieker.model.analysismodel.deployment.DeployedComponent;
import kieker.model.analysismodel.deployment.DeployedOperation;
import kieker.model.analysismodel.deployment.DeployedStorage;
import kieker.model.analysismodel.deployment.DeploymentContext;
import kieker.model.analysismodel.deployment.DeploymentModel;
import kieker.model.analysismodel.deployment.DeploymentPackage;
import kieker.model.analysismodel.execution.ExecutionModel;
import kieker.model.analysismodel.execution.ExecutionPackage;
import kieker.model.analysismodel.execution.Invocation;
import kieker.model.analysismodel.execution.OperationDataflow;
import kieker.model.analysismodel.execution.StorageDataflow;
import kieker.model.analysismodel.execution.Tuple;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.mosim.refactorlizar.architecture.evaluation.graphs.Node;
import teetime.stage.basic.AbstractTransformation;

public class AllenDeployedArchitectureGraphStage
extends AbstractTransformation<ModelRepository, Graph<Node<DeployedComponent>>> {
    private final IGraphElementSelector selector;
    private final EGraphGenerationMode graphGeneratioMode;

    public AllenDeployedArchitectureGraphStage(IGraphElementSelector selector, EGraphGenerationMode graphGeneratioMode) {
        this.selector = selector;
        this.graphGeneratioMode = graphGeneratioMode;
    }

    protected void execute(ModelRepository repository) throws Exception {
        DeploymentModel deploymentModel = (DeploymentModel)repository.getModel(DeploymentPackage.Literals.DEPLOYMENT_MODEL);
        ExecutionModel executionModel = (ExecutionModel)repository.getModel(ExecutionPackage.Literals.EXECUTION_MODEL);
        MutableGraph graph = GraphBuilder.undirected().allowsSelfLoops(true).build();
        try {
            this.selector.setRepository(repository);
            this.createNodes((MutableGraph<Node<DeployedComponent>>)graph, deploymentModel.getContexts());
            this.processInvocations((MutableGraph<Node<DeployedComponent>>)graph, executionModel.getInvocations());
            this.processOperationDataflows((MutableGraph<Node<DeployedComponent>>)graph, executionModel.getOperationDataflows());
            this.processStorageDataflows((MutableGraph<Node<DeployedComponent>>)graph, executionModel.getStorageDataflows());
            this.outputPort.send((Object)graph);
        }
        catch (InternalErrorException e) {
            this.logger.error(e.getLocalizedMessage());
        }
    }

    private void createNodes(MutableGraph<Node<DeployedComponent>> graph, EMap<String, DeploymentContext> contexts) {
        for (Map.Entry context : contexts) {
            for (Map.Entry component : ((DeploymentContext)context.getValue()).getComponents()) {
                KiekerNode node;
                for (Map.Entry operation : ((DeployedComponent)component.getValue()).getOperations()) {
                    if (!this.selector.nodeIsSelected((EObject)operation.getValue())) continue;
                    node = new KiekerNode((DeployedOperation)operation.getValue());
                    graph.addNode(node);
                }
                for (Map.Entry storage : ((DeployedComponent)component.getValue()).getStorages()) {
                    if (!this.selector.nodeIsSelected((EObject)storage.getValue())) continue;
                    node = new KiekerNode((DeployedStorage)storage.getValue());
                    graph.addNode(node);
                }
            }
        }
    }

    private void processInvocations(MutableGraph<Node<DeployedComponent>> graph, EMap<Tuple<DeployedOperation, DeployedOperation>, Invocation> invocations) throws InternalError {
        block4: for (Map.Entry entry : invocations) {
            if (!this.selector.edgeIsSelected((Invocation)entry.getValue())) continue;
            Node<DeployedComponent> source = this.findOperationNode((Graph<Node<DeployedComponent>>)graph, ((Invocation)entry.getValue()).getCaller());
            Node<DeployedComponent> target = this.findOperationNode((Graph<Node<DeployedComponent>>)graph, ((Invocation)entry.getValue()).getCallee());
            switch (this.graphGeneratioMode) {
                case ADD_NODES_FOR_EDGES: {
                    graph.putEdge(this.getOrCreateNode(graph, source, ((Invocation)entry.getValue()).getCaller()), this.getOrCreateNode(graph, target, ((Invocation)entry.getValue()).getCallee()));
                    continue block4;
                }
                case ONLY_EDGES_FOR_NODES: {
                    if (source == null || target == null) continue block4;
                    graph.putEdge(source, target);
                    continue block4;
                }
            }
            throw new InternalError("Illegal graph generation mode " + this.graphGeneratioMode.name());
        }
    }

    private void processOperationDataflows(MutableGraph<Node<DeployedComponent>> graph, EMap<Tuple<DeployedOperation, DeployedOperation>, OperationDataflow> operationDataflows) throws InternalError {
        block4: for (Map.Entry entry : operationDataflows) {
            if (!this.selector.edgeIsSelected((OperationDataflow)entry.getValue())) continue;
            Node<DeployedComponent> source = this.findOperationNode((Graph<Node<DeployedComponent>>)graph, ((OperationDataflow)entry.getValue()).getCaller());
            Node<DeployedComponent> target = this.findOperationNode((Graph<Node<DeployedComponent>>)graph, ((OperationDataflow)entry.getValue()).getCallee());
            switch (this.graphGeneratioMode) {
                case ADD_NODES_FOR_EDGES: {
                    graph.putEdge(this.getOrCreateNode(graph, source, ((OperationDataflow)entry.getValue()).getCaller()), this.getOrCreateNode(graph, target, ((OperationDataflow)entry.getValue()).getCallee()));
                    continue block4;
                }
                case ONLY_EDGES_FOR_NODES: {
                    if (source == null || target == null) continue block4;
                    graph.putEdge(source, target);
                    continue block4;
                }
            }
            throw new InternalError("Illegal graph generation mode " + this.graphGeneratioMode.name());
        }
    }

    private void processStorageDataflows(MutableGraph<Node<DeployedComponent>> graph, EMap<Tuple<DeployedOperation, DeployedStorage>, StorageDataflow> storageDataflows) throws InternalError {
        block4: for (Map.Entry entry : storageDataflows) {
            if (!this.selector.edgeIsSelected((StorageDataflow)entry.getValue())) continue;
            Node<DeployedComponent> source = this.findOperationNode((Graph<Node<DeployedComponent>>)graph, ((StorageDataflow)entry.getValue()).getCode());
            Node<DeployedComponent> target = this.findStorageNode((Graph<Node<DeployedComponent>>)graph, ((StorageDataflow)entry.getValue()).getStorage());
            switch (this.graphGeneratioMode) {
                case ADD_NODES_FOR_EDGES: {
                    graph.putEdge(this.getOrCreateNode(graph, source, ((StorageDataflow)entry.getValue()).getCode()), this.getOrCreateStorageNode(graph, target, ((StorageDataflow)entry.getValue()).getStorage()));
                    continue block4;
                }
                case ONLY_EDGES_FOR_NODES: {
                    if (source == null || target == null) continue block4;
                    graph.putEdge(source, target);
                    continue block4;
                }
            }
            throw new InternalError("Illegal graph generation mode " + this.graphGeneratioMode.name());
        }
    }

    private Node<DeployedComponent> getOrCreateStorageNode(MutableGraph<Node<DeployedComponent>> graph, Node<DeployedComponent> node, DeployedStorage storage) {
        if (node == null) {
            KiekerNode newNode = new KiekerNode(storage);
            graph.addNode(newNode);
            return newNode;
        }
        return node;
    }

    private Node<DeployedComponent> getOrCreateNode(MutableGraph<Node<DeployedComponent>> graph, Node<DeployedComponent> node, DeployedOperation operation) {
        if (node == null) {
            KiekerNode newNode = new KiekerNode(operation);
            graph.addNode(newNode);
            return newNode;
        }
        return node;
    }

    private Node<DeployedComponent> findOperationNode(Graph<Node<DeployedComponent>> graph, DeployedOperation operation) {
        Optional<Node> operationNode = graph.nodes().stream().filter(node -> ((KiekerNode)node).getMember() instanceof DeployedOperation).filter(node -> !((DeployedComponent)node.getModule()).getOperations().isEmpty()).filter(node -> ((DeployedOperation)((KiekerNode)node).getMember()).equals(operation)).findFirst();
        if (operationNode.isPresent()) {
            return operationNode.get();
        }
        return null;
    }

    private Node<DeployedComponent> findStorageNode(Graph<Node<DeployedComponent>> graph, DeployedStorage storage) {
        for (Node node : graph.nodes()) {
            KiekerNode kiekerNode;
            if (!((DeployedComponent)node.getModule()).getOperations().isEmpty() || !((DeployedStorage)(kiekerNode = (KiekerNode)node).getMember()).equals(storage)) continue;
            return kiekerNode;
        }
        return null;
    }
}

