/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.metrics.graph.entropy;

import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.HashSet;
import java.util.Map;
import kieker.analysis.architecture.repository.ModelRepository;
import kieker.analysis.generic.graph.IGraphElementSelector;
import kieker.analysis.metrics.graph.entropy.KiekerNode;
import kieker.model.analysismodel.deployment.DeployedComponent;
import kieker.model.analysismodel.deployment.DeployedOperation;
import kieker.model.analysismodel.deployment.DeployedStorage;
import kieker.model.analysismodel.deployment.DeploymentContext;
import kieker.model.analysismodel.deployment.DeploymentModel;
import kieker.model.analysismodel.deployment.DeploymentPackage;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.mosim.refactorlizar.architecture.evaluation.graphs.Node;
import teetime.stage.basic.AbstractTransformation;

public class AllenDeployedMaximalInterconnectedGraphStage
extends AbstractTransformation<ModelRepository, Graph<Node<DeployedComponent>>> {
    private final IGraphElementSelector selector;

    public AllenDeployedMaximalInterconnectedGraphStage(IGraphElementSelector selector) {
        this.selector = selector;
    }

    protected void execute(ModelRepository repository) throws Exception {
        DeploymentModel deploymentModel = (DeploymentModel)repository.getModel(DeploymentPackage.Literals.DEPLOYMENT_MODEL);
        MutableGraph graph = GraphBuilder.undirected().allowsSelfLoops(true).build();
        this.createNodes((MutableGraph<Node<DeployedComponent>>)graph, deploymentModel.getContexts());
        this.interconnectAllNodes((MutableGraph<Node<DeployedComponent>>)graph);
        this.outputPort.send((Object)graph);
    }

    private void createNodes(MutableGraph<Node<DeployedComponent>> graph, EMap<String, DeploymentContext> contexts) {
        for (Map.Entry context : contexts) {
            for (Map.Entry component : ((DeploymentContext)context.getValue()).getComponents()) {
                KiekerNode node;
                for (Map.Entry operation : ((DeployedComponent)component.getValue()).getOperations()) {
                    if (!this.selector.nodeIsSelected((EObject)operation.getValue())) continue;
                    node = new KiekerNode((DeployedOperation)operation.getValue());
                    graph.addNode(node);
                }
                for (Map.Entry storage : ((DeployedComponent)component.getValue()).getStorages()) {
                    if (!this.selector.nodeIsSelected((EObject)storage.getValue())) continue;
                    node = new KiekerNode((DeployedStorage)storage.getValue());
                    graph.addNode(node);
                }
            }
        }
    }

    private void interconnectAllNodes(MutableGraph<Node<DeployedComponent>> graph) {
        HashSet processedNodes = new HashSet();
        graph.nodes().forEach(source -> {
            processedNodes.add(source);
            graph.nodes().stream().filter(target -> !processedNodes.contains(target)).forEach(target -> graph.putEdge(source, target));
        });
    }
}

