/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.metrics.graph.entropy;

import com.google.common.graph.Graph;
import java.util.HashMap;
import java.util.Map;
import org.mosim.refactorlizar.architecture.evaluation.CalculationMode;
import org.mosim.refactorlizar.architecture.evaluation.codemetrics.CodeMetric;
import org.mosim.refactorlizar.architecture.evaluation.codemetrics.Cohesion;
import org.mosim.refactorlizar.architecture.evaluation.codemetrics.Complexity;
import org.mosim.refactorlizar.architecture.evaluation.codemetrics.Coupling;
import org.mosim.refactorlizar.architecture.evaluation.codemetrics.HyperGraphSize;
import org.mosim.refactorlizar.architecture.evaluation.codemetrics.LinesOfCode;
import org.mosim.refactorlizar.architecture.evaluation.cohesion.HyperGraphCohesionCalculator;
import org.mosim.refactorlizar.architecture.evaluation.complexity.HyperGraphComplexityCalculator;
import org.mosim.refactorlizar.architecture.evaluation.coupling.HyperGraphInterModuleCouplingGenerator;
import org.mosim.refactorlizar.architecture.evaluation.graphs.Node;
import org.mosim.refactorlizar.architecture.evaluation.graphs.SystemGraphUtils;
import org.mosim.refactorlizar.architecture.evaluation.size.HyperGraphSizeCalculator;
import teetime.stage.basic.AbstractTransformation;

public class ComputeAllenComplexityMetrics<T>
extends AbstractTransformation<Graph<Node<T>>, Map<Class<? extends CodeMetric>, CodeMetric>> {
    private final Class<? extends CodeMetric>[] metrics;
    private final SystemGraphUtils<T> systemGraphUtils;

    @SafeVarargs
    public ComputeAllenComplexityMetrics(SystemGraphUtils<T> systemGraphUtils, Class<? extends CodeMetric> ... metrics) {
        this.metrics = metrics;
        this.systemGraphUtils = systemGraphUtils;
    }

    protected void execute(Graph<Node<T>> graph) throws Exception {
        CalculationMode mode = CalculationMode.NO_OFFSET;
        HashMap<Class<? extends CodeMetric>, HyperGraphSize> result = new HashMap<Class<? extends CodeMetric>, HyperGraphSize>();
        for (Class<? extends CodeMetric> metricClass : this.metrics) {
            Object metric = metricClass.equals(HyperGraphSize.class) ? this.calculateHyperGraphSize(mode, this.systemGraphUtils, graph) : (metricClass.equals(Complexity.class) ? new HyperGraphComplexityCalculator(mode, this.systemGraphUtils).calculate(graph) : (metricClass.equals(Coupling.class) ? new HyperGraphInterModuleCouplingGenerator(mode, this.systemGraphUtils).calculate(graph) : (metricClass.equals(Cohesion.class) ? new HyperGraphCohesionCalculator(mode, this.systemGraphUtils).calculate(graph) : (metricClass.equals(LinesOfCode.class) ? new LinesOfCode((double)graph.nodes().size()) : null))));
            result.put(metricClass, (HyperGraphSize)metric);
        }
        this.outputPort.send(result);
    }

    private HyperGraphSize calculateHyperGraphSize(CalculationMode mode, SystemGraphUtils<T> internalSystemGraphUtils, Graph<Node<T>> graph) {
        return new HyperGraphSize(new HyperGraphSizeCalculator(mode).calculate((Graph)internalSystemGraphUtils.convertToSystemGraph(graph)));
    }
}

