/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.metrics.graph.entropy;

import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.List;
import kieker.analysis.architecture.repository.ModelRepository;
import kieker.analysis.metrics.graph.entropy.KiekerNode;
import kieker.model.analysismodel.deployment.DeployedComponent;
import kieker.model.analysismodel.deployment.DeployedOperation;
import kieker.model.analysismodel.deployment.DeploymentContext;
import kieker.model.analysismodel.deployment.DeploymentModel;
import kieker.model.analysismodel.deployment.DeploymentPackage;
import kieker.model.analysismodel.execution.ExecutionModel;
import kieker.model.analysismodel.execution.ExecutionPackage;
import kieker.model.analysismodel.execution.Invocation;
import org.mosim.refactorlizar.architecture.evaluation.graphs.Node;
import teetime.stage.basic.AbstractTransformation;

public class CreateGraph4AllenMetricStage
extends AbstractTransformation<ModelRepository, Graph<Node<DeployedComponent>>> {
    protected void execute(ModelRepository element) throws Exception {
        Graph<Node<DeployedComponent>> graph = this.computeGraph(element);
        this.outputPort.send(graph);
    }

    private Graph<Node<DeployedComponent>> computeGraph(ModelRepository repository) {
        MutableGraph<Node<DeployedComponent>> graph = this.createGraph();
        DeploymentModel deploymentModel = (DeploymentModel)repository.getModel(DeploymentPackage.Literals.DEPLOYMENT_MODEL);
        ExecutionModel executionModel = (ExecutionModel)repository.getModel(ExecutionPackage.Literals.EXECUTION_MODEL);
        for (DeployedOperation operation : this.collectAllOperations(deploymentModel)) {
            graph.addNode(new KiekerNode(operation));
            this.getReferencedMembers(operation, executionModel).forEach(calledOperation -> graph.putEdge(new KiekerNode((DeployedOperation)calledOperation), new KiekerNode(operation)));
        }
        return graph;
    }

    private Iterable<DeployedOperation> getReferencedMembers(DeployedOperation operation, ExecutionModel executionModel) {
        ArrayList<DeployedOperation> callees = new ArrayList<DeployedOperation>();
        for (Invocation invocation : executionModel.getInvocations().values()) {
            if (!invocation.getCaller().equals(operation)) continue;
            callees.add(invocation.getCallee());
        }
        return callees;
    }

    private List<DeployedOperation> collectAllOperations(DeploymentModel deploymentModel) {
        ArrayList<DeployedOperation> operations = new ArrayList<DeployedOperation>();
        for (DeploymentContext context : deploymentModel.getContexts().values()) {
            for (DeployedComponent component : context.getComponents().values()) {
                for (DeployedOperation operation : component.getOperations().values()) {
                    operations.add(operation);
                }
            }
        }
        return operations;
    }

    private MutableGraph<Node<DeployedComponent>> createGraph() {
        return GraphBuilder.undirected().allowsSelfLoops(true).build();
    }
}

